% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_metrics.R
\name{sim_metrics_helper}
\alias{sim_metrics_helper}
\title{Helper function to compute metrics.}
\usage{
sim_metrics_helper(
  collated_sim,
  sim_type_signal,
  sim_type_background,
  summary_cols,
  annotation_cols,
  identifier = NULL,
  use_furrr = FALSE
)
}
\arguments{
\item{collated_sim}{output of \code{sim_collated}, which is a data.frame with
some attributes.}

\item{sim_type_signal}{character string specifying the type of
replication being measured. This must be one of the strings \code{"rep"}
or \code{"rep_group"}.}

\item{sim_type_background}{character string specifying the background
distributions for computing scaled metrics. This must be one of the
strings \code{"non_rep"} or \code{"ref"}.}

\item{summary_cols}{character list specifying columns by which to group
similarities.}

\item{annotation_cols}{character list specifying annotation columns.}

\item{identifier}{character string specifying the identifier to add as a
suffix to the columns containing scaled-aggregated metrics.}

\item{use_furrr}{boolean indicating whether to use the furrr library
for parallel processing.}
}
\value{
data.frame of metrics.
}
\description{
\code{sim_metrics_helper} helps compute metrics by aggregating and
scaling.
}
