\name{matrixdist-package}
\alias{matrixdist-package}
\alias{matrixdist}
\docType{package}
\title{
  Statistics for Matrix Distributions
}
\description{
  This package implements tools which are useful for the statistical analysis of discrete, continuous, multivariate, right-censored or regression variants of phase-type distributions. These distributions are absorption times of Markov jump processes, and thus the maximization of their likelihood for statistical estimation is best dealt with using the EM algorithm.
}
\author{
Martin Bladt and Jorge Yslas.

Maintainer: Martin Bladt <martinbladt@gmail.com>
}
\references{
  Asmussen, S., Nerman, O., & Olsson, M. (1996). Fitting phase-type distributions via the EM 
  algorithm. Scandinavian Journal of Statistics, 23(4),419-441.
  
  Olsson, M. (1996). Estimation of phase-type distributions from censored data. Scandinavian journal of statistics, 24(4), 443-460.
  
  Albrecher, H., & Bladt, M. (2019). Inhomogeneous phase-type distributions and heavy tails. Journal of Applied Probability, 56(4), 1044-1064.
  
  Albrecher, H., Bladt, M., & Yslas, J. (2022). Fitting inhomogeneous Phase-Type distributions to data: The univariate and the multivariate case. Scandinavian Journal of Statistics, 49(1), 44-77
  
  Albrecher, H., Bladt, M., Bladt, M., & Yslas, J. (2020). Mortality modeling and regression with matrix distributions. Insurance: Mathematics and Economics, 107, 68-87.
  
  Bladt, M., & Yslas, J. (2022). Phase-type mixture-of-experts regression for loss severities. ScandinavianActuarialJournal, 1-27.
  
  Bladt, M. (2022). Phase-type distributions for claim severity regression modeling. ASTIN Bulletin: The journal of the IAA, 52(2), 417-448.
  
  Bladt, M. (2023). A tractable class of Multivariate Phase-type distributions for loss modeling. North American Actuarial Journal, to appear.
  
  Albrecher, H., Bladt, M., & Mueller, A. (2023). Joint lifetime modelling with matrix distributions. Dependence Modeling, 11(1), 1-22.
  
  Bladt, M. & Yslas, J. (2023). Robust claim frequency modeling through phase-type mixture-of-experts regression.Insurance: Mathematics and Economics, 111, 1-22.
  
}
\keyword{ matrixdist }
