% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{remove_anno}
\alias{remove_anno}
\alias{remove_row_annotation}
\alias{remove_column_annotation}
\title{Remove meta info of a \code{matrixset}}
\usage{
remove_row_annotation(.ms, ...)

remove_column_annotation(.ms, ...)
}
\arguments{
\item{.ms}{A \code{matrixset} object}

\item{...}{Name of traits to remove. Tidy selection is supported.}
}
\value{
A \code{matrixset} with updated row or column meta info.
}
\description{
Deletes row or column annotation (i.e., trait).

The tag is a special trait that can't be removed. The tag is the column name
of the meta data frame that holds the row or column names. The tag identity
of the' object can be obtained via \code{\link[=row_tag]{row_tag()}} or \code{\link[=column_tag]{column_tag()}}.
}
\section{Groups}{

Removing a trait that is used for grouping is not allowed and will not work.
}

\examples{
ms1 <- remove_row_annotation(student_results, class, teacher)

# this doesn't work because "class" is used for grouping
ms2 <- tryCatch(remove_row_annotation(row_group_by(student_results, class), class),
                error = function(e) e)
is(ms2, "error") #TRUE
ms2$message
}
