% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apply.R
\name{prepare_.FUNdots}
\alias{prepare_.FUNdots}
\title{Prepare the \code{.FUNdots} argument for \verb{*apply_byname} functions.}
\usage{
prepare_.FUNdots(a, .FUNdots)
}
\arguments{
\item{a}{the main argument to an \verb{*apply_byname} function.}

\item{.FUNdots}{a list of additional arguments to be applied to \code{FUN} in one of the \verb{*apply_byname} functions.}
}
\value{
a reconfigured version of \code{.FUNdots}, ready for use by an \verb{*apply_byname} function.
\itemize{
\item both a and the item of .FUNdots are lists
\itemize{
\item if the item of .FUNdots (a list itself) has length different from 1 or length(a), throw an error
\item if the item of .FUNdots (a list itself) has length 1, replicate the single item to be a list of length = length(a)
\item if the item of .FUNdots (a list itself) has length = length(a), use the item of .FUNdots as is
}
\item a is NOT a list, but the item of .FUNdots IS a list
\itemize{
\item pass the argument along and hope for the best.  This situation is probably an error.
If so, it will become apparent soon.
}
\item a is a list but the item (argument) of .FUNdots is NOT a list
This situation could be ambiguous.
Let's say the list of \code{a} values has length 2, and an argument \code{margin = c(1, 2)}.
Should \code{margin = 1} be applied to \code{a[[1]]} and \code{margin = 2} be applied to \code{a[[2]]}?
Or should \code{margin = c(1, 2)} be applied to both \code{a[[1]]} and \code{a[[2]]}?
This ambiguity should be handled by using the function \code{prep_vector_arg()}
within the function that calls \code{unaryapply_byname()}.
For an example, see \code{identize_byname()}.
When the arguments are coming in from a data frame, there will be no ambiguity,
but the information will not be coming \code{.FUNdots[[i]]} as a list.
Optimizing for the data frame case,
this function allows vectors of length equal to the length of the list \code{a},
interpreting such vectors as applying in sequence to each \code{a} in turn.
So the algorithm is as follows:
\itemize{
\item if a non-NULL item of .FUNdots (which is not a list) has
length other than 1 or length(a), throw an error.
\item if a non-NULL item of .FUNdots (which is not a list) has length = 1,
replicate that single item to be a list of length = length(a).
\item if a non-NULL item of .FUNdots (which is not a list) has length = length(a),
leave it as-is.
}
\item neither a nor the item of .FUNdots is a list
\itemize{
\item a should have length = 1, but a single matrix reports its length as the number of elementes of the matrix.
So, we can't check length in this situation.
\item the item of .FUNdots is assumed to have length 1 and passed along
}
}
}
\description{
This is a helper function for the various \verb{*apply_byname} functions.
}
\details{
We have four cases between a and any single item of .FUNdots:
\itemize{
\item both a and the item of .FUNdots are lists
\itemize{
\item if the item of .FUNdots (a list itself) has length different from 1 or length(a), throw an error
\item if the item of .FUNdots (a list itself) has length 1, replicate the single item to be a list of length = length(a)
\item if the item of .FUNdots (a list itself) has length = length(a), use the item of .FUNdots as is
}
\item a is a list but the item (argument) of .FUNdots is NOT a list
\itemize{
\item if the item of .FUNdots (which is not a list) has length != 1, throw an error,
because there is ambiguity how the item of .FUNdots should be treated.
\item if the item of .FUNdots (which is not a list) has length = 1, replicate that single item to be a list of length = length(a)
}
\item a is NOT a list, but the item of .FUNdots IS a list
\itemize{
\item pass the argument along and hope for the best.  This situation is probably an error.  If so, it will become apparent soon.
}
\item neither a nor the item of .FUNdots is a list
\itemize{
\item a should have length = 1, but a single matrix reports its length as the number of elementes of the matrix.
So, we can't check length in this situation.
\item the item of .FUNdots is assumed to have length 1 and passed along
}
}
}
