% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_Matrix.R
\name{Matrix}
\alias{Matrix}
\title{Create a Matrix amenable to use in the \code{matsbyname} package}
\usage{
Matrix(
  data = NA,
  nrow = 1,
  ncol = 1,
  byrow = FALSE,
  dimnames = base::dimnames(data),
  sparse = NULL,
  doDiag = FALSE,
  forceCheck = FALSE,
  rowtype = matsbyname::rowtype(data),
  coltype = matsbyname::coltype(data)
)
}
\arguments{
\item{data}{An optional numeric data vector or matrix.}

\item{nrow}{When \code{data} is not a \code{matrix} or a \code{Matrix}, the desired number of rows.
Default is \code{1}.}

\item{ncol}{When \code{data} is not a \code{matrix} or a \code{Matrix}, the desired number of columns.
Default is \code{1}.}

\item{byrow}{A boolean. If \code{FALSE} (the default) the Matrix is filled by columns, otherwise the Matrix is filled by rows.}

\item{dimnames}{A dimnames attribute for the Matrix: a list of two character components.
Default is \code{base::dimnames(data)}.}

\item{sparse}{A boolean or \code{NULL}. Specifies whether the result should be sparse or not.
By default (\code{NULL}), the Matrix is made sparse when more than half
of the entries are \code{0}.}

\item{doDiag}{A boolean indicating if a \code{diagonalMatrix} object should be returned
when the resulting Matrix is diagonal (mathematically).
Default is \code{FALSE}, which is different from \code{Matrix::Matrix()}.}

\item{forceCheck}{A boolean indicating if the checks for structure should happen
when \code{data} is already a \code{Matrix} object.
Default is \code{FALSE}.}

\item{rowtype}{The rowtype for the result. Default is \code{matsbyname::rowtype(data)}.}

\item{coltype}{The coltype for the result. Default is \code{matsbyname::coltype(data)}.}
}
\value{
A \code{Matrix} object.
}
\description{
The \code{matsbyname} package uses \code{Matrix} objects for its
default data representation, taking advantage
of the sparse matrix capabilities of \code{Matrix} compared
to the base \code{matrix} class.
This function routes to \code{Matrix::Matrix()}, with some important
differences. See details.
}
\details{
This function NEVER creates a symmetric matrix,
because symmetric matrices do not respect some future changes to \code{dimnames},
which can cause information loss in the \code{matsbyname} context.
A non-symmetric \code{Matrix} is assured by calling \code{as(out, "generalMatrix")}
on the outgoing \code{Matrix} object.

This function enables setting row and column types at the time of construction
with the \code{rowtype} and \code{coltype} arguments.

This function has different defaults compared to \code{Matrix::Matrix()}, including
\itemize{
\item Here, the default for \code{doDiag} is \code{FALSE},
while the default for \code{doDiag} is \code{TRUE} for \code{Matrix::Matrix()}.
\item Preserves rowtype and coltype on \code{data}.
}
}
\examples{
# matsbyname::Matrix() will not create a Matrix with a symmetric subclass.
# dgCMatrix is a general matrix.
matsbyname::Matrix(c(1, 0, 2, 
                     0, 0, 0, 
                     2, 0, 0), byrow = TRUE, nrow = 3, ncol = 3)
# But Matrix::Matrix() will create a symmetric matrix.
# dsCMatrix is a symmetric matrix.
Matrix::Matrix(c(1, 0, 2, 
                 0, 0, 0, 
                 2, 0, 0), byrow = TRUE, nrow = 3, ncol = 3)
# matsbyname::Matrix() will not create a diagonal matrix.
# dgeMatrix is a general matrix.
matsbyname::Matrix(c(1, 0, 
                     0, 1), byrow = TRUE, nrow = 2, ncol = 2)
# But Matrix::Matrix() will create a diagonal matrix.
# ddiMatrix is a diagonal matrix.
Matrix::Matrix(c(1, 0, 
                 0, 1), byrow = TRUE, nrow = 2, ncol = 2)
}
