% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_beast2_pkg_names.R
\name{get_beast2_pkg_names}
\alias{get_beast2_pkg_names}
\title{List all BEAST2 packages available and installed}
\usage{
get_beast2_pkg_names()
}
\value{
a data frame
}
\description{
Will \link{stop} if there is no internet connection
}
\examples{
library(testthat)

if (is_beast2_installed() && curl::has_internet()) {
  df <- get_beast2_pkg_names()
  expect_true("name" \%in\% names(df))
  expect_true("installed_version" \%in\% names(df))
  expect_true("latest_version" \%in\% names(df))
  expect_true("dependencies" \%in\% names(df))
  expect_true("description" \%in\% names(df))
}
}
\author{
Richèl J.C. Bilderbeek
}
