% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nodf_cpp}
\alias{nodf_cpp}
\title{Raw NODF calculation}
\usage{
nodf_cpp(mtx)
}
\arguments{
\item{mtx}{A numeric matrix describing a bipartite network (a bipartite incidence matrix where elements are positive numbers if nodes interact, and 0 otherwise).}
}
\value{
Returns the NODF of the network.
}
\description{
Calculates the raw NODF of a bipartite incidence matrix
}
\details{
For a given network, \code{nodf_cpp} calculates the raw NODF value. Calculation is fast as the code is implemented in C++.
}
\examples{
set.seed(123)
nodf_cpp(matrix(sample(x = 0:1, size = 100, replace = TRUE),10,10))
}
