% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_cell_draws_and_summarize.R
\name{generate_cell_draws_and_summarize}
\alias{generate_cell_draws_and_summarize}
\title{Generate cell draws and summary rasters from INLA model}
\usage{
generate_cell_draws_and_summarize(
  inla_model,
  inla_mesh,
  n_samples,
  id_raster,
  covariates,
  inverse_link_function,
  nugget_in_predict = TRUE,
  admin_boundaries = NULL,
  ui_width = 0.95,
  verbose = TRUE
)
}
\arguments{
\item{inla_model}{Output from \code{\link[=fit_inla_model]{fit_inla_model()}}}

\item{inla_mesh}{An SPDE mesh used to define the spatial integration points of the INLA
geostatistical model. Typically created using \code{\link[INLA:inla.mesh.2d]{INLA::inla.mesh.2d()}} or a similar
function.}

\item{n_samples}{(numeric) Number of posterior predictive samples to draw.}

\item{id_raster}{(\link[terra:SpatRaster-class]{terra::SpatRaster}) raster showing all cell locations where
predictions should be taken.}

\item{covariates}{(list) Named list of all covariate effects included in the model,
typically generated by \code{\link[=load_covariates]{load_covariates()}}.}

\item{inverse_link_function}{(character) If a link function was used in the INLA model,
name of the R function to transform the predictive draws from link space to natural
space. For example, in a logit-linked binomial model, pass 'plogis' (as a string is
fine) to invert-logit the predictive draws.}

\item{nugget_in_predict}{(\code{logical(1)}, default TRUE) Should the nugget term be used as
an IID noise term applied to each pixel-draw?}

\item{admin_boundaries}{(\link[sf:sf]{sf} object, default NULL) The same admin boundaries
used to create the admin-level effect, if one was defined in the model. Only used if
an admin-level effect was defined in the model.}

\item{ui_width}{(numeric, default 0.95) Size of the uncertainty interval width when
calculating the upper and lower summary rasters}

\item{verbose}{(\code{logical(1)}, default TRUE) Log progress for draw generation?}
}
\value{
Named list containing at least the following items:
\itemize{
\item "parameter_draws": posterior samples generated from \code{\link[INLA:posterior.sample]{INLA::inla.posterior.sample()}}
\item "cell_draws": A matrix of grid cell draws. Each row represents a non-NA pixel in
the \code{id_raster}, in the same order that would be pulled by \code{\link[terra:values]{terra::values()}}, and
each column represents a different posterior draw.
\item "cell_pred_mean": Mean predictive estimate by grid cell, formatted as a terra
SpatRaster
\item "cell_pred_lower": Lower bound of (X\%) uncertainty interval, formatted as a terra
SpatRaster
\item "cell_pred_upper": Upper bound of (X\%) uncertainty interval, formatted as a terra
SpatRaster
}
}
\description{
Use INLA posteriors to predict out across a grid
}
\details{
Based on a fitted INLA model, the survey area defined in an ID raster, and a set of
covariates, generate predictive grid cell draws and summary rasters across a study
area.
}
\concept{prediction}
