% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Procedures.R
\name{plot_model}
\alias{plot_model}
\title{Plot structural change model}
\usage{
plot_model(model, CI = 0.95, title = NULL)
}
\arguments{
\item{model}{object of class \code{model} in \code{mbreaks} package}

\item{CI}{confidence intervals for break date and coefficient estimates visualize in terms of
fitted values}

\item{title}{title of the graph}
}
\value{
No return value, called for plotting class \code{model} object. For more details
on \code{model} class, see \link{compile_model}
}
\description{
\code{plot_model()} visualizes any object of class \code{model} with comparison between real,
fitted values between  model of \code{m} breaks and null model of \code{0} breaks with options
for confidence interval of break date.
}
\examples{
rate = dofix('rate',data=real,fixn=2)
plot_model(rate,title='Ex-post US exchange rate')

}
