% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWeight.R
\name{getWeight}
\alias{getWeight}
\title{Get the overall costs/weight of a subgraph given its edgelist.}
\usage{
getWeight(graph, edgelist)
}
\arguments{
\item{graph}{[\code{mcGP}]\cr
Multi-objective graph problem.}

\item{edgelist}{[\code{matrix(2, k)}]
Matrix of edges (each column is one edge).}
}
\value{
[\code{numeric(2)}] Weight vector.
}
\description{
Get the overall costs/weight of a subgraph given its edgelist.
}
\examples{
# generate a random bi-objective graph
g = genRandomMCGP(5)

# generate a random Pruefer code, i.e., a random spanning tree of g
pcode = sample(1:5, 3, replace = TRUE)

getWeight(g, prueferToEdgeList(pcode))
}
