% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcMSTPrim.R
\name{mcMSTPrim}
\alias{mcMSTPrim}
\title{Multi-Objective Prim algorithm.}
\usage{
mcMSTPrim(instance, n.lambdas = NULL, lambdas = NULL)
}
\arguments{
\item{instance}{[\code{mcGP}]\cr
Multi-objective graph problem.}

\item{n.lambdas}{[\code{integer(1) | NULL}]\cr
Number of weights to generate. The weights are generated equdistantly
in the interval \eqn{[0, 1]}.}

\item{lambdas}{[\code{numerci}]\cr
Vector of weights. This is an alternative to \code{n.lambdas}.}
}
\value{
[\code{list}] List with component \code{pareto.front}.
}
\description{
Approximates the Pareto-optimal mcMST front of a multi-objective
graph problem by iteratively applying Prim's algorithm for the single-objective
MST problem to a scalarized version of the problem. I.e., the weight vector
\eqn{(w_1, w_2)} of an edge \eqn{(i, j)} is substituted with a weighted
sum \eqn{\lambda_i w_1 + (1 - \lambda_i) w_2} with weight \eqn{\lambda_i \in [0, 1]}
for different weights.
}
\note{
Note that this procedure can only find socalled supported efficient
solutions, i.e., solutions on the convex hull of the Pareto-optimal front.
}
\examples{
g = genRandomMCGP(30)
res = mcMSTPrim(g, n.lambdas = 50)
print(res$pareto.front)
}
\references{
J. D. Knowles and D. W. Corne, "A comparison of encodings and
algorithms for multiobjective minimum spanning tree problems," in Proceedings
of the 2001 Congress on Evolutionary Computation (IEEE Cat. No.01TH8546),
vol. 1, 2001, pp. 544–551 vol. 1.
}
\seealso{
Other mcMST algorithms: \code{\link{mcMSTEmoaBG}},
  \code{\link{mcMSTEmoaZhou}}
}
