% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_dist.R
\name{mc_dist}
\alias{mc_dist}
\title{Distance Models Structure}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mc_dist(id, time, data, method = "euclidean")
}
\arguments{
\item{id}{name of the column (string) containing the subject index.
For spatial data use the same \code{id} for all observations (one unit sample).}

\item{time}{name of the column (string) containing the index
indicating the time. For spatial data use the same index for all observations.}

\item{data}{data set.}

\item{method}{distance measure to be used.}
}
\value{
A matrix of dgCMatrix class.
}
\description{
The function \code{mc_dist} helps to build the components
of the matrix linear predictor using matrices based on distances.
This function is generaly used for the analysis of longitudinal and
spatial data. The idea is to use the inverse of some measure of distance
as for example the Euclidean distance to model the covariance structure
within response variables. The model can also use the inverse of
distance squared or high order power.
}
\details{
The distance measure must be one of \code{"euclidean"},
\code{"maximum"}, \code{"manhattan"}, \code{"canberra"},
\code{"binary"} or \code{"minkowski"}. This function is a customize
call of the \code{\link[stats]{dist}} function.
}
\examples{
id <- rep(1:2, each = 4)
time <- rep(1:4, 2)
data <- data.frame("id" = id, "time" = time)
mc_dist(id = "id", time = "time", data = data)
mc_dist(id = "id", time = "time", data = data, method = "canberra")
}
\seealso{
\code{\link[stats]{dist}}, \code{mc_id},
\code{mc_conditional_test}, \code{mc_car}, \code{mc_ma},
\code{mc_rw} and \code{mc_mixed}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
