% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\encoding{UTF-8}
\name{plot_pars}
\alias{plot_pars}
\title{Plot individual parameters}
\usage{
plot_pars(
  fit,
  pars = "population",
  regex_pars = character(0),
  type = "combo",
  ncol = 1,
  prior = FALSE
)
}
\arguments{
\item{fit}{An \code{\link{mcpfit}} object.}

\item{pars}{Character vector. One of:
\itemize{
\item Vector of parameter names.
\item \emph{"population" (default):} plots all population parameters.
\item \emph{"varying":} plots all varying effects. To plot a particular varying
effect, use \code{regex_pars = "^name"}.
}}

\item{regex_pars}{Vector of regular expressions. This will typically just be
the beginning of the parameter name(s), i.e., "^cp_" plots all change
points, "^my_varying" plots all levels of a particular varying effect, and
"^cp_|^my_varying" plots both.}

\item{type}{String or vector of strings. Calls \verb{bayesplot::mcmc_>>type<<()}.
Common calls are "combo", "trace", and "dens_overlay". Current options include
'acf', 'acf_bar', 'areas', 'areas_ridges', 'combo', 'dens', 'dens_chains',
'dens_overlay', 'hist', 'intervals', 'rank_hist', 'rank_overlay', 'trace',
'trace_highlight', and 'violin".}

\item{ncol}{Number of columns in plot. This is useful when you have many
parameters and only one plot \code{type}.}

\item{prior}{TRUE/FALSE. Plot using prior samples? Useful for \code{mcp(..., sample = "both")}}
}
\value{
A \pkg{ggplot2} object.
}
\description{
Plot many types of plots of parameter estimates. See examples for typical use
cases.
}
\details{
For other \code{type}, it calls \code{bayesplot::mcmc_type()}. Use these
directly on \code{fit$mcmc_post} or \code{fit$mcmc_prior} if you want finer
control of plotting, e.g., \code{bayesplot::mcmc_dens(fit$mcmc_post)}. There
are also a number of useful plots in the \pkg{coda} package, i.e.,
\code{coda::gelman.plot(fit$mcmc_post)} and \code{coda::crosscorr.plot(fit$mcmc_post)}

In any case, if you see a few erratic lines or parameter estimates, this is
a sign that you may want to increase argument 'adapt' and 'iter' in \code{\link{mcp}}.
}
\examples{
# Typical usage. ex_fit is an mcpfit object.
plot_pars(ex_fit)

# More options
plot_pars(ex_fit, regex_pars = "^cp_")  # Plot only change points
plot_pars(ex_fit, pars = c("int_3", "time_3"))  # Plot these parameters
plot_pars(ex_fit, type = c("trace", "violin"))  # Combine plots

\dontrun{
# Some plots only take pairs. hex is good to assess identifiability
plot_pars(ex_fit, type = "hex", pars = c("cp_1", "time_2"))

# Visualize the priors:
plot_pars(ex_fit, prior = TRUE)

# Useful for varying effects:
# plot_pars(my_fit, pars = "varying", ncol = 3)  # plot all varying effects
# plot_pars(my_fit, regex_pars = "my_varying", ncol = 3)  # plot all levels of a particular varying

# Customize multi-column ggplots using "*" instead of "+" (patchwork)
library(ggplot2)
plot_pars(ex_fit, type = c("trace", "dens_overlay")) * theme_bw(10)
}
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
