% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpfit_methods.R
\encoding{UTF-8}
\name{fitted.mcpfit}
\alias{fitted.mcpfit}
\alias{fitted}
\title{Expected Values from the Posterior Predictive Distribution}
\usage{
\method{fitted}{mcpfit}(
  object,
  newdata = NULL,
  summary = TRUE,
  probs = TRUE,
  rate = TRUE,
  prior = FALSE,
  which_y = "ct",
  varying = TRUE,
  arma = TRUE,
  nsamples = NULL,
  samples_format = "tidy",
  scale = "response",
  ...
)
}
\arguments{
\item{object}{An \code{mcpfit} object.}

\item{newdata}{A \code{tibble} or a \code{data.frame} containing predictors in the model. If \code{NULL} (default),
the original data is used.}

\item{summary}{Summarise at each x-value}

\item{probs}{Vector of quantiles. Only in effect when \code{summary == TRUE}.}

\item{rate}{Boolean. For binomial models, plot on raw data (\code{rate = FALSE}) or
response divided by number of trials (\code{rate = TRUE}). If FALSE, linear
interpolation on trial number is used to infer trials at a particular x.}

\item{prior}{TRUE/FALSE. Plot using prior samples? Useful for \code{mcp(..., sample = "both")}}

\item{which_y}{What to plot on the y-axis. One of
\itemize{
\item \code{"ct"}: The central tendency which is often the mean after applying the
link function.
\item \code{"sigma"}: The variance
\item \code{"ar1"}, \code{"ar2"}, etc. depending on which order of the autoregressive
effects you want to plot.
}}

\item{varying}{One of:
\itemize{
\item \code{TRUE} All varying effects (\code{fit$pars$varying}).
\item \code{FALSE} No varying effects (\code{c()}).
\item Character vector: Only include specified varying parameters - see \code{fit$pars$varying}.
}}

\item{arma}{Whether to include autoregressive effects.
\itemize{
\item \code{TRUE} Compute autoregressive residuals. Requires the response variable in \code{newdata}.
\item \code{FALSE} Disregard the autoregressive effects. For \code{family = gaussian()}, \code{predict()} just use \code{sigma} for residuals.
}}

\item{nsamples}{Integer or \code{NULL}. Number of samples to return/summarise.
If there are varying effects, this is the number of samples from each varying group.
\code{NULL} means "all". Ignored if both are \code{FALSE}. More samples trade speed for accuracy.}

\item{samples_format}{One of "tidy" or "matrix". Controls the output format when \code{summary == FALSE}.
See more under "value"}

\item{scale}{One of
\itemize{
\item "response": return on the observed scale, i.e., after applying the inverse link function.
\item "linear": return on the parameter scale (where the linear trends are modelled).
}}

\item{...}{Currently ignored.}
}
\value{
\itemize{
\item If \code{summary = TRUE}: A \code{tibble} with the posterior mean for each row in \code{newdata},
If \code{newdata} is \code{NULL}, the data in \code{fit$data} is used.
\item If \code{summary = FALSE} and \code{samples_format = "tidy"}: A \code{tidybayes} \code{tibble} with all the posterior
samples (\code{Ns}) evaluated at each row in \code{newdata} (\code{Nn}), i.e., with \verb{Ns x Nn} rows. If there are
varying effects, the returned data is expanded with the relevant levels for each row.

The return columns are:
\itemize{
\item Predictors from \code{newdata}.
\item Sample descriptors: ".chain", ".iter", ".draw" (see the \code{tidybayes} package for more), and "data_row" (\code{newdata} rownumber)
\item Sample values: one column for each parameter in the model.
\item The estimate. Either "predict" or "fitted", i.e., the name of the \code{type} argument.
}
\item If \code{summary = FALSE} and \code{samples_format = "matrix"}: An \code{N_draws} X \code{nrows(newdata)} matrix with fitted/predicted
values (depending on \code{type}). This format is used by \code{brms} and it's useful as \code{yrep} in
\verb{bayesplot::ppc_*} functions.
}
}
\description{
Expected Values from the Posterior Predictive Distribution
}
\examples{
\donttest{
fitted(demo_fit)
fitted(demo_fit, probs = c(0.1, 0.5, 0.9))  # With median and 80\% credible interval.
fitted(demo_fit, summary = FALSE)  # Samples instead of summary.
fitted(demo_fit,
       newdata = data.frame(time = c(-5, 20, 300)),  # New data
       probs = c(0.025, 0.5, 0.975))
}

}
\seealso{
\code{\link{pp_eval}} \code{\link{predict.mcpfit}} \code{\link{residuals.mcpfit}}
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
