% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdu.R
\name{sd24}
\alias{sd24}
\title{Compute MCTQ 24 hours sleep duration (only for MCTQ\eqn{^{Shift}}{ Shift})}
\usage{
sd24(sd, napd, nap)
}
\arguments{
\item{sd}{A \code{\link[lubridate:duration]{Duration}} object corresponding to the
\strong{sleep duration} from the shift version of the MCTQ questionnaire. You
can use \code{\link[=sdu]{sdu()}} to compute it.}

\item{napd}{A \code{\link[lubridate:duration]{Duration}} object corresponding to the
\strong{nap duration} from the shift version of the MCTQ questionnaire. You can
use \code{\link[=napd]{napd()}} to compute it.}

\item{nap}{A \code{\link[base:logical]{logical}} value corresponding to the \strong{"I
usually take a nap"} response from the shift version of the MCTQ
questionnaire.}
}
\value{
\itemize{
\item If \code{nap == TRUE}, a \code{\link[lubridate:duration]{Duration}} object
corresponding to the vectorized sum of \code{sd} and \code{napd} in a circular time
frame of 24 hours.
\item If \code{nap == FALSE}, a \code{\link[lubridate:duration]{Duration}} object equal to
\code{sd}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{sd24()} computes the \strong{24 hours sleep duration} for the shift version of
the Munich ChronoType Questionnaire (MCTQ).
}
\details{
\strong{Standard MCTQ} functions were created following the guidelines in
Roenneberg, Wirz-Justice, & Merrow (2003), Roenneberg, Allebrandt, Merrow, &
Vetter (2012), and from The Worldwide Experimental Platform (theWeP, n.d.).

\strong{\eqn{\mu}MCTQ} functions were created following the guidelines in Ghotbi
et al. (2020), in addition to the guidelines used for the standard MCTQ.

\strong{MCTQ\eqn{^{Shift}}{ Shift}} functions were created following the
guidelines in Juda, Vetter, & Roenneberg (2013), in addition to the
guidelines used for the standard MCTQ.

See the References section to learn more.
\subsection{Class requirements}{

The \code{mctq} package works with a set of object classes specially created to
hold time values. These classes can be found in the
\link[lubridate:lubridate-package]{lubridate} and \link[hms:hms-package]{hms}
packages. Please refer to those package documentations to learn more about
them.
}

\subsection{Rounding and fractional time}{

Some operations may produce an output with fractional time (e.g.,
\code{"19538.3828571429s (~5.43 hours)"}, \code{01:15:44.505}). If you want, you
can round it with \code{\link[=round_time]{round_time()}}.

Our recommendation is to avoid rounding, but, if you do, make sure that you
only round your values after all computations are done. That way you avoid
\href{https://en.wikipedia.org/wiki/Round-off_error}{round-off errors}.
}
}
\section{Guidelines}{


Juda, Vetter & Roenneberg (2013) and The Worldwide Experimental Platform
(n.d.) guidelines for \code{sd24()} (\eqn{SD24}) computation are as follows.
\subsection{Notes}{
\itemize{
\item This computation must be applied to each section of the questionnaire.
\item If the respondent don't usually take a nap in a particular shift \strong{or}
between two free days after a particular shift, \code{sd24()} will return only
\eqn{SD_{W/F}^{M/E/N}}{SD_W/F_M/E/N}.
\item If you are visualizing this documentation in plain text, you may have some
trouble understanding the equations. You can see this documentation on the
package \href{https://docs.ropensci.org/mctq/reference/}{website}.
}
}

\subsection{Computation}{

\deqn{SD24_{W/F}^{M/E/N} = SD_{W/F}^{M/E/N} + NapD_{W/F}^{M/E/N}}

Where:
\itemize{
\item \eqn{SD24_{W/F}^{M/E/N}} = 24 hours sleep duration between two days in a
particular shift \strong{or} between two free days after a particular shift.
\item \eqn{SD_{W/F}^{M/E/N}} = Sleep duration between two days in a particular
shift \strong{or} between two free days after a particular shift.
\item \eqn{NapD_{W/F}^{M/E/N}} = Nap duration between two days in a particular
shift \strong{or} between two free days after a particular shift.
}

\strong{*} \eqn{W} = Workdays; \eqn{F} = Work-free days, \eqn{M} =
Morning shift; \eqn{E} = Evening shift; \eqn{N} = Night shift.
}
}

\examples{
## Scalar example

sd <- lubridate::dhours(6)
napd <- lubridate::dhours(0.5)
nap <- TRUE
sd24(sd, napd, nap)
#> [1] "23400s (~6.5 hours)" # Expected

sd <- lubridate::dhours(9)
napd <- lubridate::dhours(1.5)
nap <- TRUE
sd24(sd, napd, nap)
#> [1] "37800s (~10.5 hours)" # Expected

sd <- lubridate::dhours(6.5)
napd <- lubridate::as.duration(NA)
nap <- FALSE
sd24(sd, napd, nap)
#> [1] "23400s (~6.5 hours)" # Expected

sd <- lubridate::as.duration(NA)
napd <- lubridate::dhours(2.3)
nap <- TRUE
sd24(sd, napd, nap)
#> [1] NA # Expected

## Vector example

sd <- c(lubridate::dhours(7.5), lubridate::dhours(8))
napd <- c(lubridate::dhours(0.75), lubridate::dhours(1))
nap <- c(TRUE, TRUE)
sd24(sd, napd, nap)
#> [1] "29700s (~8.25 hours)" "32400s (~9 hours)" # Expected
}
\references{
Ghotbi, N., Pilz, L. K., Winnebeck, E. C., Vetter, C., Zerbini, G., Lenssen,
D., Frighetto, G., Salamanca, M., Costa, R., Montagnese, S., & Roenneberg, T.
(2020). The \eqn{\mu}MCTQ: an ultra-short version of the Munich ChronoType
Questionnaire. \emph{Journal of Biological Rhythms}, \emph{35}(1), 98-110.
\doi{10.1177/0748730419886986}.

Juda, M., Vetter, C., & Roenneberg, T. (2013). The Munich ChronoType
Questionnaire for shift-workers (MCTQ\eqn{^{Shift}}{ Shift}). \emph{Journal of
Biological Rhythms}, \emph{28}(2), 130-140. \doi{10.1177/0748730412475041}.

Roenneberg T., Allebrandt K. V., Merrow M., & Vetter C. (2012). Social jetlag
and obesity. \emph{Current Biology}, \emph{22}(10), 939-43.
\doi{10.1016/j.cub.2012.03.038}.

Roenneberg, T., Wirz-Justice, A., & Merrow, M. (2003). Life between clocks:
daily temporal patterns of human chronotypes. \emph{Journal of Biological
Rhythms}, \emph{18}(1), 80-90. \doi{10.1177/0748730402239679}.

The Worldwide Experimental Platform (n.d.). MCTQ.
\url{https://www.thewep.org/documentations/mctq/}
}
\seealso{
Other MCTQ functions: 
\code{\link{fd}()},
\code{\link{gu}()},
\code{\link{le_week}()},
\code{\link{msf_sc}()},
\code{\link{msl}()},
\code{\link{napd}()},
\code{\link{sd_overall}()},
\code{\link{sd_week}()},
\code{\link{sdu}()},
\code{\link{sjl_sc}()},
\code{\link{sjl_weighted}()},
\code{\link{sjl}()},
\code{\link{so}()},
\code{\link{tbt}()}
}
\concept{MCTQ functions}
