/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.scrollabledesktop;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import multidendrograms.forms.scrollabledesktop.BaseInternalFrame;
import multidendrograms.forms.scrollabledesktop.DesktopMediator;
import multidendrograms.forms.scrollabledesktop.FrameAccessorInterface;

public class DesktopListener
implements ComponentListener,
ActionListener {
    private DesktopMediator desktopMediator;

    public DesktopListener(DesktopMediator desktopMediator) {
        this.desktopMediator = desktopMediator;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.desktopMediator.resizeDesktop();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.desktopMediator.revalidateViewport();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.desktopMediator.resizeDesktop();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Tile")) {
            this.desktopMediator.tileInternalFrames();
        } else if (string.equals("Cascade")) {
            this.desktopMediator.cascadeInternalFrames();
        } else if (string.equals("Close")) {
            this.desktopMediator.closeSelectedFrame();
        } else if (string.equals("TileRadio")) {
            this.desktopMediator.setAutoTile(true);
        } else if (string.equals("CascadeRadio")) {
            this.desktopMediator.setAutoTile(false);
        } else {
            BaseInternalFrame baseInternalFrame = ((FrameAccessorInterface)actionEvent.getSource()).getAssociatedFrame();
            if (baseInternalFrame != null) {
                baseInternalFrame.selectFrameAndAssociatedButtons();
                this.desktopMediator.centerView(baseInternalFrame);
            }
        }
    }
}

