% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdgc.R
\name{mdgc_start_value}
\alias{mdgc_start_value}
\alias{mdgc_start_value.mdgc}
\alias{mdgc_start_value.default}
\title{Get Starting Value for the Covariance Matrix Using a Heuristic}
\usage{
mdgc_start_value(object, ...)

\method{mdgc_start_value}{mdgc}(object, ...)

\method{mdgc_start_value}{default}(
  object,
  lower,
  upper,
  code,
  multinomial,
  idx_non_zero_mean,
  mea,
  n_threads = 1L,
  ...
)
}
\arguments{
\item{object}{mdgc object from \code{\link{get_mdgc}}. Ignored by
the default method.}

\item{...}{used to pass arguments to S3 methods.}

\item{lower}{[# variables]x[# observations] matrix with lower bounds
for each variable on the normal scale.}

\item{upper}{[# variables]x[# observations] matrix with upper bounds
for each variable on the normal scale.}

\item{code}{[# variables]x[# observations] matrix integer code for the
each variable on the normal scale. Zero implies an observed value (the
value in \code{upper}), one implies a missing value, and two implies an
interval.}

\item{multinomial}{\code{\link{list}} where each element is
3x[# multinomial variables] \code{\link{matrix}} with
multinomial outcomes. The first index is the outcome as an integer code,
the second index is the number of categories, and the third index is the
index of each multinomial variable (this is zero-based).}

\item{idx_non_zero_mean}{indices for non-zero mean variables. Indices
should be sorted.}

\item{mea}{vector with non-zero mean entries.}

\item{n_threads}{number of threads to use.}
}
\value{
The starting value for the covariance matrix.
}
\description{
Uses a heuristic to get starting values for the covariance matrix. These
can be passed e.g. to \code{\link{mdgc_fit}}.
}
\examples{
# randomly mask data
set.seed(11)
masked_data <- iris
masked_data[matrix(runif(prod(dim(iris))) < .10, NROW(iris))] <- NA

# use the functions in the package
library(mdgc)
obj <- get_mdgc(masked_data)
ptr <- get_mdgc_log_ml(obj)
start_vals <- mdgc_start_value(obj)
start_vals # starting value for the covariance matrix

}
