% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A2L.R
\name{Adj2Lap}
\alias{Adj2Lap}
\title{Compute a graph Laplacian matrix from a graph Adjacency matrix}
\usage{
Adj2Lap(Adj)
}
\arguments{
\item{Adj}{graph Adjacency matrix (squared symmetric matrix)}
}
\value{
graph Laplacian matrix
}
\description{
Compute a graph Laplacian matrix from a graph Adjacency matrix
}
\examples{
# Create exemplary graph Adjacency matrix
p1 <- 10
p2 <- 90
p <- p1 + p2
A <- matrix(rep(0, p * p), p, p)
A[1:p1, 1:p1] <- 1
A[(p1 + 1):p, (p1 + 1):p] <- 1
vizu.mat(A, "Adjacency matrix")

# Compute corresponding graph Laplacian matrix
L <- Adj2Lap(A)
vizu.mat(L, "Laplacian matrix")
}

