% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_device_events.R
\name{deviceevent}
\alias{deviceevent}
\title{MD-PMS Device Event Data Frame}
\usage{
deviceevent(data_frame, time, device_hierarchy, event_hierarchy,
  key = NULL, covariates = NULL, descriptors = NULL,
  time_invivo = NULL)
}
\arguments{
\item{data_frame}{The input data frame requiring components specified in the
remaining arguments.}

\item{time}{Character name of date variable in \code{data_frame}
corresponding to the event. Class must be Date, POSIXt, or character.

Example: \code{"event_date"}}

\item{device_hierarchy}{Vector of character variable names representing the
device hierarchy in \code{data_frame}. Vector ordering is lowest level first,
most general level last. If more than 2 variables, see important note in 
Details.

Example: \code{c("Version", "Device", "ProductLine")}}

\item{event_hierarchy}{Vector of character variable names representing the
event hierarchy in \code{data_frame}. Vector ordering is most specific event
category first, most broad event category last. If more than 2 variables,
see important note in Details.

Example: \code{c("Event Code", "Event Group")}}

\item{key}{Character name of (uniquely identifying) primary key variable in
\code{data_frame}. Class must be character or numeric.

Example: \code{"key_ID"}

Default: \code{NULL} will create a key variable.}

\item{covariates}{Vector of character variable names representing the
desired covariates to retain, all of which must be of class \code{numeric}
or \code{factor}.  \code{"_all_"} includes all covariates, assumed
to be remaining variables in \code{data_frame} not already specified in
\code{key}, \code{time}, \code{device_hierarchy}, or \code{event_hierarchy}.
Covariates must be numeric, categorical, or binary in nature.

Example: \code{c("Reporter", "Operation Time", "Country")}

Default: \code{NULL} includes no covariates.}

\item{descriptors}{Vector of character variable names representing additional
descriptive variables that will not be used in any analyses but may be
recalled or displayed later during individual device-event review.
\code{"_all_"} includes all remaining variables in \code{data_frame} not
already specified in \code{key}, \code{time}, \code{device_hierarchy},
\code{event_hierarchy}, or \code{covariates}. Typical descriptors are
free text or high-dimensional categoricals.

Example: \code{c("Description", "Unique Device Identifier")}

Default: \code{NULL} includes no descriptors.}

\item{time_invivo}{Character name of numeric variable in \code{data_frame}
representing the time in vivo of the device at the time of the event
\code{time}. See details for more.

IMPORTANT: If a call to \code{define_analyses()} is planned,
\code{time_invivo} must be in the time units specified collectively by its
parameters \code{date_level} and \code{date_level_n}.

Example: \code{"Implanted Months"}. A value of \code{45} in the
variable \code{data_frame$'Implanted Months'} would indicate 45 units of time
elapsed since the device was first in vivo. If \code{date_level="months"} and
\code{date_level_n=1}, this will be interpreted by \code{define_analyses()}
as 45 months.

Default: \code{NULL} indicates this variable will not be used.}
}
\value{
A standardized MD-PMS data frame of class \code{mds_de}.
Rows are deduplicated. Attributes are as follows:
\describe{
  \item{key}{Original variable name for \code{key}}
  \item{time}{Original variable name for \code{time}}
  \item{device_hierarchy}{Vector of original variable names for
  \code{device_hierarchy} with converted variable names correspondingly
  named.}
  \item{event_hierarchy}{Vector of original variable names for
  \code{event_hierarchy} with converted variable names correspondingly
  named.}
  \item{covariates}{Vector of original variable names for
  \code{covariates} with converted variable names correspondingly
  named.}
  \item{descriptors}{Vector of original variable names for
  \code{descriptors} with converted variable names correspondingly
  named.}
}
}
\description{
Converts a data frame into a MD-PMS Device Event data frame.
}
\details{
When more than 2 variables are specified in either \code{device_hierarchy} 
or \code{event_hierarchy}, it is important to note that a subsequent call to
\code{define_analyses()} currently only utilizes a maximum of 2 variables: 
the lowest level and the 1-level-up parent. The user may enforce full
hierarchy in >2 variable cases by ensuring that the parent values are
uniquely named.

\code{time_invivo} can be thought of more generally as the time of
exposure of the device to the subject at the time of the event. The common
usage is duration of the implant in the patient at time of event, for an
implantable medical device.
}
\examples{
# A barebones dataset
de <- deviceevent(maude, "date_received", "device_name", "event_type")
# With more variables and variable types
de <- deviceevent(
  data_frame=maude,
  time="date_received",
  device_hierarchy=c("device_name", "device_class"),
  event_hierarchy=c("event_type", "medical_specialty_description"),
  key="report_number",
  covariates=c("region"),
  descriptors="_all_")

}
