% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hydrology_snowMelt}
\alias{hydrology_snowMelt}
\alias{hydrology_verticalInputs}
\alias{hydrology_waterInputs}
\title{Water vertical inputs}
\usage{
hydrology_snowMelt(tday, rad, LgroundSWR, elevation)

hydrology_waterInputs(
  x,
  prec,
  rainfallIntensity,
  pet,
  tday,
  rad,
  elevation,
  Cm,
  LgroundPAR,
  LgroundSWR,
  modifyInput = TRUE
)
}
\arguments{
\item{tday}{Average day temperature (ºC).}

\item{rad}{Solar radiation (in MJ/m2/day).}

\item{LgroundSWR}{Percentage of short-wave radiation (SWR) reaching the ground.}

\item{elevation}{Altitude above sea level (m).}

\item{x}{An object of class \code{\link{spwbInput}} or \code{\link{growthInput}}.}

\item{prec}{Precipitation for the given day (mm)}

\item{rainfallIntensity}{Rainfall intensity rate (mm/h).}

\item{pet}{Potential evapotranspiration for the given day (mm)}

\item{Cm}{Canopy water storage capacity.}

\item{LgroundPAR}{Percentage of photosynthetically-active radiation (PAR) reaching the ground.}

\item{modifyInput}{Boolean flag to indicate that the input \code{x} object should be modified during the simulation.}
}
\value{
Function \code{hydrology_waterInputs} returns a named vector with the following elements, all in mm:
\item{Rain}{Precipitation as rainfall.}
\item{Snow}{Precipitation as snow.}
\item{Interception}{Rainfall water intercepted by the canopy and evaporated.}
\item{Snowmelt}{Snow melted during the day, and added to the water infiltrated.}
\item{NetRain}{Rainfall reaching the ground.}
}
\description{
High-level functions to define water inputs into the soil of a stand:

\itemize{
\item{Function \code{hydrology_waterInputs} performs canopy water interception and snow accumulation/melt.}
\item{Function \code{hydrology_snowMelt} estimates snow melt using a simple energy balance, according to Kergoat (1998).}
}
}
\details{
The function simulates different vertical hydrological processes, which are described separately in other functions.
If \code{modifyInput = TRUE} the function will modify the \code{x} object (including both soil moisture and
the snowpack on its surface) as a result of simulating hydrological processes.
}
\references{
Kergoat L. (1998). A model for hydrological equilibrium of leaf area index on a global scale. Journal of Hydrology 212–213: 268–286.
}
\seealso{
\code{\link{spwb_day}}, \code{\link{hydrology_rainInterception}}, \code{\link{hydrology_soilEvaporation}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
\keyword{internal}
