% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neModel.R
\name{neModel-methods}
\alias{neModel-methods}
\alias{coef.neModel}
\alias{confint.neModelBoot}
\alias{confint.neModel}
\alias{residualPlot.neModel}
\alias{residualPlots.neModel}
\alias{summary.neModel}
\alias{vcov.neModel}
\alias{weights.neModel}
\title{Methods for natural effect models}
\usage{
\method{coef}{neModel}(object, ...)

\method{confint}{neModelBoot}(object, parm, level = 0.95,
  type = "norm", ...)

\method{confint}{neModel}(object, parm, level = 0.95, ...)

\method{residualPlot}{neModel}(object, ...)

\method{residualPlots}{neModel}(object, ...)

\method{summary}{neModel}(object, ...)

\method{vcov}{neModel}(object, ...)

\method{weights}{neModel}(object, ...)
}
\arguments{
\item{object}{a fitted natural effect model object.}

\item{...}{additional arguments.}

\item{parm}{a specification of which parameters are to be given
    confidence intervals, either a vector of numbers or a vector of
    names.  If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{type}{the type of bootstrap intervals required. The default \code{"norm"} returns normal approximation bootstrap confidence intervals. Currently, \code{"norm"}, \code{"basic"}, \code{"perc"} and \code{"bca"} are supported (see \code{\link[boot]{boot.ci}}).}
}
\description{
Extractor functions, confidence intervals, residual plots and statistical tests for natural effect models.
}
\details{
\code{confint} yields bootstrap confidence intervals or confidence intervals based on the sandwich estimator (depending on the type of standard errors requested when fitting the \code{\link{neModel}} object). 
Bootstrap confidence intervals are internally called via the \code{\link[boot]{boot.ci}} function from the \pkg{boot} package.
Confidence intervals based on the sandwich estimator are internally called via \code{\link[stats]{confint.default}}.
The default confidence level specified in \code{level} (which corresponds to the \code{conf} argument in \code{\link[boot]{boot.ci}}) is 0.95
and the default type of bootstrap confidence interval, \code{"norm"}, is based on the normal approximation.
Bias-corrected and accelerated (\code{"bca"}) bootstrap confidence intervals require a sufficiently large number of bootstrap replicates (for more details see \code{\link[boot]{boot.ci}}).

A summary table with large sample tests, similar to that for \code{\link[stats]{glm}} output, can be obtained using \code{summary}.

\code{vcov} returns either the bootstrap variance-covariance matrix (calculated from the bootstrap samples stored in\cr \code{object$bootRes}; see \code{\link{neModel}})
or the robust variance-covariance matrix (which is a diagonal block matrix of the original sandwich covariance matrix).

\code{weights} returns a vector containing the regression weights used to fit the natural effect model.
These weights can be based on
\enumerate{
 \item ratio-of-mediator probability (density) weights (only if the weighting-based approach is used)
 \item inverse probability of treatment (exposure) weights (only if \code{xFit} was specified in \code{\link{neModel}})
}

\code{residualPlot} and \code{residualPlots} are convenience functions from the \pkg{car} package. These can be used to assess model adequacy.
}
\note{
For the bootstrap, \emph{z}-values in the summary table are calculated by dividing the parameter estimate by its corresponding bootstrap standard error. 
Corresponding \emph{p}-values in the summary table are indicative, since the null distribution for each statistic is assumed to be approximately standard normal.
Therefore, whenever possible, it is recommended to focus mainly on bootstrap confidence intervals for inference, rather than the provided \emph{p}-values.
}
\examples{
data(UPBdata)

weightData <- neWeight(negaff ~ att + educ + gender + age,
                       data = UPBdata)
neMod <- neModel(UPB ~ att0 * att1 + educ + gender + age, 
                 family = binomial, expData = weightData, se = "robust")

## extract coefficients
coef(neMod)

## extract variance-covariance matrix
vcov(neMod)

## extract regression weights
w <- weights(neMod)
head(w)

## obtain bootstrap confidence intervals
confint(neMod)
confint(neMod, parm = c("att0"))
confint(neMod, type = "perc", level = 0.90)

## summary table
summary(neMod)

## residual plots
library(car)
residualPlots(neMod)
}
\seealso{
\code{\link{neModel}}, \code{\link{plot.neModel}}, \code{\link[car]{residualPlot}}, \code{\link[car]{residualPlots}}, \code{\link{weights}}
}
