% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{charlson_weights_orig}
\alias{charlson_weights_orig}
\title{Map of Charlson comorbidity categories to weights}
\format{A list, with Charlson comorbidities as names and weight as value}
\usage{
charlson_weights_orig
}
\description{
List that links the Charlson comorbidity categories to the original
weights (specified in the original Charlson paper, Table 3)
}
\details{
Original Weights:

1 = MI, CHF, PVD, CVD, Dementia, Chronic pulm dz, Connective tissue dz,
Ulcer, Mild liver dz, Diabetes

2 = Hemiplegia, Mod or severe renal dz, Diabetes with end organ damage, Any
tumor, Leukemia, Lymphoma

3 = Moderate or severe liver dz

6 = Metastatic solid tumor, AIDS
}
\examples{
charlson_weights_orig["aids"]
}
\references{
1. Charlson ME, Pompei P, Ales KL, MacKenzie CR: A new method of
  classifying prognostic comorbidity in longitudinal studies: development and
  validation. Journal of chronic diseases 1987; 40:373-83
  \url{http://www.ncbi.nlm.nih.gov/pubmed/3558716}
}
\seealso{
\code{\link{charlson_weights}},
\code{\link{icd9cm_charlson_deyo}},
\code{\link{icd9cm_charlson_romano}},
\code{\link{icd9cm_charlson_quan}},
\code{\link{melt_icd9list}}
}
\keyword{datasets}

