#' @title medicare: tools for simplifying Medicare data analysis
#' @name medicare
#'   
#' @description The medicare package contains useful functions for manipulating
#'   raw Medicare public use files. These sometimes come with SAS read-in code
#'   provided, but more frequently require the analyst to manually recode and
#'   rename variables based on thorough review of the data documentation. This
#'   package focuses mostly on Cost Reports and Provider of Service files, but
#'   more support will be added for other sources in the future.
#'   
#' @seealso For more information on Medicare the the data available, see:
#' 
#' \itemize{
#' \item \href{https://www.cms.gov/Research-Statistics-Data-and-Systems/Research-Statistics-Data-and-Systems.html}{CMS's website on publicly available data}
#' \item \href{https://www.cms.gov/Research-Statistics-Data-and-Systems/Downloadable-Public-Use-Files/Cost-Reports/index.html}{CMS's documentation and download links for Cost Report data}
#' \item \href{https://www.cms.gov/Research-Statistics-Data-and-Systems/Downloadable-Public-Use-Files/Provider-of-Services/index.html}{CMS's documentation and download links for Provider of Services data}
#' }
#'  
#'   
#' @docType package
#' @aliases medicare medicare-package

NULL
