% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ControlEL-class}
\alias{ControlEL-class}
\alias{ControlEL}
\title{\linkS4class{ControlEL} class}
\description{
S4 class for computational details of empirical likelihood.
}
\section{Slots}{

\describe{
\item{\code{maxit}}{A single integer for the maximum number of iterations for the
optimization with respect to \eqn{\theta}.}

\item{\code{maxit_l}}{A single integer for the maximum number of iterations for the
optimization with respect to \eqn{\lambda}.}

\item{\code{tol}}{A single numeric for the convergence tolerance denoted by
\eqn{\epsilon}. The iteration stops when
\deqn{\|P \nabla l(\theta^{(k)})\| < \epsilon.}}

\item{\code{tol_l}}{A single numeric for the relative convergence tolerance denoted
by \eqn{\delta}. The iteration stops when
\deqn{\|\lambda^{(k)} - \lambda^{(k - 1)}\| <
\delta\|\lambda^{(k - 1)}\| + \delta^2.}}

\item{\code{step}}{A single numeric for the step size \eqn{\gamma} for the projected
gradient descent method.}

\item{\code{th}}{A single numeric for the threshold for the negative empirical
log-likelihood ratio.}

\item{\code{verbose}}{A single logical for whether to print a message on the
convergence status.}

\item{\code{keep_data}}{A single logical for whether to}

\item{\code{nthreads}}{A single integer for the number of threads for parallel
computation via OpenMP (if available).}

\item{\code{seed}}{A single integer for the seed for random number generation.}

\item{\code{b}}{A single integer for the number of bootstrap replicates.}

\item{\code{m}}{A single integer for the number of Monte Carlo samples.}
}}

\examples{
showClass("ControlEL")
}
