% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memsurveillance.R
\name{memsurveillance}
\alias{memsurveillance}
\title{Creates the surveillance graph of the current season}
\usage{
memsurveillance(i.current, i.epidemic.thresholds = NA,
  i.intensity.thresholds = NA, i.mean.length = 10, i.force.length = F,
  i.output = ".", i.graph.title = "", i.graph.subtitle = "",
  i.graph.file = T, i.graph.file.name = "", i.week.report = NA,
  i.equal = F, i.pos.epidemic = F, i.no.epidemic = F,
  i.no.intensity = F, i.epidemic.start = NA, i.range.x = c(40, 20),
  i.range.x.53 = F, i.range.y = NA, i.no.labels = F,
  i.start.end.marks = T)
}
\arguments{
\item{i.current}{Current season weekly rates.}

\item{i.epidemic.thresholds}{Pre and post epidemic threholds.}

\item{i.intensity.thresholds}{Intensity thresholds.}

\item{i.mean.length}{Mean length of epidemic.}

\item{i.force.length}{If you want to force the epidemic to be exactly as the mean length.}

\item{i.output}{Directory where graph is saved.}

\item{i.graph.title}{Title of the graph.}

\item{i.graph.subtitle}{Subtitle of the graph.}

\item{i.graph.file}{Graph to a file.}

\item{i.graph.file.name}{Name of the graph.}

\item{i.week.report}{Week to use in the report.}

\item{i.equal}{If post epidemic and preepidemic thresholds must be equal (force post epidemic to be equal to the pre epidemic threshold).}

\item{i.pos.epidemic}{Print post epidemic threhsold.}

\item{i.no.epidemic}{Force no start of the epidemic, print only the epidemic threshold.}

\item{i.no.intensity}{Do not print intensity threholds.}

\item{i.epidemic.start}{Week to force start of the epidemic.}

\item{i.range.x}{Range of weeks.}

\item{i.range.x.53}{Is there a week 53 this season.}

\item{i.range.y}{Range of graph.}

\item{i.no.labels}{Do not use labels.}

\item{i.start.end.marks}{Do not place start and end marks of the epidemic.}
}
\value{
\code{memsurveillance} writes a tiff graph of the surveillance of this season.
}
\description{
Function \code{memsurveillance} creates a surveillance graph for the current season.
}
\details{
Input data must be the current season and an object of class \code{mem}. The output
graph contains the weekly rates series along with the epidemic and intensity threshols
located at the exact situation where the epidemic started. If there is no epidemic yet,
only the epidemic threshold is placed.
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# Data of the last season
cur<-flucyl[8]
# The model
epi<-memmodel(flucyl[1:7])
# Epidemic thresholds
e.thr<-epi$epidemic.thresholds
# Intensity threhsolds
i.thr<-epi$intensity.thresholds
# Set the working directory to whererever you want to store the graph file
setwd(".")
# The graph, default values
m1<-memsurveillance(cur,e.thr,i.thr,i.graph.file=TRUE,
     i.graph.file.name="graph 1")
# No intensity levels
m2<-memsurveillance(cur,e.thr,i.thr,i.graph.file=TRUE,
     i.graph.file.name="graph 2",i.no.intensity=TRUE)
# No start/end tickmarks
m3<-memsurveillance(cur,e.thr,i.thr,i.graph.file=TRUE,
     i.graph.file.name="graph 3",i.start.end.marks=FALSE)
# Post-epidemic threshold
m4<-memsurveillance(cur,e.thr,i.thr,i.graph.file=TRUE,
     i.graph.file.name="graph 4",i.pos.epidemic=TRUE)
# Report for week 2, instead of all data
m5<-memsurveillance(cur,e.thr,i.thr,i.graph.file=TRUE,
     i.graph.file.name="graph 5",i.week.report=2)

}
\references{
Vega Alonso, Tomas, Jose E Lozano Alonso, Raul Ortiz de Lejarazu, and Marisol Gutierrez Perez. 2004.
Modelling Influenza Epidemic: Can We Detect the Beginning and Predict the Intensity and Duration?
International Congress Series, Options for the Control of Influenza V. Proceedings of the International
Conference on Options for the Control of Influenza V, 1263 (June): 281-83. doi:10.1016/j.ics.2004.02.121.\cr
Vega, Tomas, Jose Eugenio Lozano, Tamara Meerhoff, Rene Snacken, Joshua Mott, Raul Ortiz de Lejarazu, and
Baltazar Nunes. 2013. Influenza Surveillance in Europe: Establishing Epidemic Thresholds by the Moving
Epidemic Method. Influenza and Other Respiratory Viruses 7 (4): 546-58. doi:10.1111/j.1750-2659.2012.00422.x.\cr
Vega, Tomas, Jose E. Lozano, Tamara Meerhoff, Rene Snacken, Julien Beaute, Pernille Jorgensen, Raul Ortiz
de Lejarazu, et al. 2015. Influenza Surveillance in Europe: Comparing Intensity Levels Calculated Using
the Moving Epidemic Method. Influenza and Other Respiratory Viruses 9 (5): 234-46. doi:10.1111/irv.12330.
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
