# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

set <- function(v) {
    .Call('_memnet_set', PACKAGE = 'memnet', v)
}

mset <- function(dat) {
    .Call('_memnet_mset', PACKAGE = 'memnet', dat)
}

indx <- function(s, set) {
    .Call('_memnet_indx', PACKAGE = 'memnet', s, set)
}

lags <- function(dat, l, na_rm = TRUE) {
    .Call('_memnet_lags', PACKAGE = 'memnet', dat, l, na_rm)
}

strsplit <- function(s, delim) {
    .Call('_memnet_strsplit', PACKAGE = 'memnet', s, delim)
}

getinds <- function(pairs, unis) {
    .Call('_memnet_getinds', PACKAGE = 'memnet', pairs, unis)
}

getpairs <- function(spairs, del) {
    .Call('_memnet_getpairs', PACKAGE = 'memnet', spairs, del)
}

count <- function(v) {
    .Call('_memnet_count', PACKAGE = 'memnet', v)
}

range <- function(n) {
    .Call('_memnet_range', PACKAGE = 'memnet', n)
}

get_indices <- function(n, use) {
    .Call('_memnet_get_indices', PACKAGE = 'memnet', n, use)
}

cut_stringvec <- function(items, indices) {
    .Call('_memnet_cut_stringvec', PACKAGE = 'memnet', items, indices)
}

cut_dat <- function(dat, inds, indices) {
    .Call('_memnet_cut_dat', PACKAGE = 'memnet', dat, inds, indices)
}

mcount <- function(dat) {
    .Call('_memnet_mcount', PACKAGE = 'memnet', dat)
}

getprob <- function(counts, N) {
    .Call('_memnet_getprob', PACKAGE = 'memnet', counts, N)
}

pinwin <- function(n, l) {
    .Call('_memnet_pinwin', PACKAGE = 'memnet', n, l)
}

mpinwin <- function(ns, l) {
    .Call('_memnet_mpinwin', PACKAGE = 'memnet', ns, l)
}

lens <- function(dat) {
    .Call('_memnet_lens', PACKAGE = 'memnet', dat)
}

mlength <- function(dat) {
    .Call('_memnet_mlength', PACKAGE = 'memnet', dat)
}

getplink <- function(inds, probs, pinwin) {
    .Call('_memnet_getplink', PACKAGE = 'memnet', inds, probs, pinwin)
}

dbinom <- function(k, n, p) {
    .Call('_memnet_dbinom', PACKAGE = 'memnet', k, n, p)
}

pbinom <- function(k, n, p) {
    .Call('_memnet_pbinom', PACKAGE = 'memnet', k, n, p)
}

#' Create community graph
#'
#' Create a graph from verbal fluency data by adding edges for words that occur
#' within a window size \code{l} and retaining those that occur more frequently
#' than \code{min_cooc} and the expectations number of chance productions co-
#' occurences based on \code{1-crit}.
#'
#' @param dat list of character vectors containing the fluency productions.
#' @param l an integer specifying the window size. The internal upper limit
#'   of \code{l} is the number of productions.
#' @param crit a numeric within \code{[0,1]} specifiying the type-1 error
#'   rate of including an edge between unconnected words.
#' @param min_cooc integer specifying the minimum number of times two words
#'   have to coocur within a window size of \code{l} to consider including
#'   an edge between them.
#'
#' @return
#' A matrix
#'
#' @references
#'
#' Goni, J., Arrondo, G., Sepulcre, J., Martincorena, I., de Mendizábal, N. V.,
#' Corominas-Murtra, B., ... & Villoslada, P. (2011). The semantic organization
#' of the animal category: evidence from semantic verbal fluency and network
#' theory. Cognitive processing, 12(2), 183-196.
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' @examples
#'
#' # get animal fluency data
#' data(animal_fluency)
#'
#' # infer influence network
#' inferred_network = community_graph(animal_fluency)
#'
#' # Simulate -----
#'
#' # generate watts strogatz graph
#' network = grow_ws(n = 200, k = 10, p = .5)
#'
#' # generate fluency data
#' # sets string equal TRUE as community_graph expects mode character
#' fluency_data = fluency(get_adjlist(network), rep(10, 100), string = TRUE)
#'
#' # infer fluency network
#' inferred_network = community_graph(fluency_data)
#'
#' @export
community_graph <- function(dat, l = 3L, min_cooc = 2L, crit = .05) {
    .Call('_memnet_community_graph', PACKAGE = 'memnet', dat, l, min_cooc, crit)
}

#' Create random walk graph
#'
#' Create a random walk graph from verbal fluency data that includes edges for words
#' that occur within a window size of 1.
#'
#' @param dat list of character vectors containing the fluency productions.
#'
#' @return
#' A matrix
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Zemla, J. C., & Austerweil, J. L. (2018). Estimating semantic networks of
#' groups and individuals from fluency data. Computational Brain & Behavior,
#' 1-23.
#'
#' @examples
#'
#' # get animal fluency data
#' data(animal_fluency)
#'
#' # infer influence network
#' inferred_network = rw_graph(animal_fluency)
#'
#' # Simulate -----
#'
#' # generate watts strogatz graph
#' network = grow_ws(n = 200, k = 10, p = .5)
#'
#' # generate fluency data
#' # sets string equal TRUE as community_graph expects mode character
#' fluency_data = fluency(get_adjlist(network), rep(10, 100), string = TRUE)
#'
#' # infer fluency network
#' inferred_network = rw_graph(fluency_data)
#'
#' @export
rw_graph <- function(dat) {
    .Call('_memnet_rw_graph', PACKAGE = 'memnet', dat)
}

#' Create threshold graph
#'
#' Create a graph from verbal fluency data by adding edges for words that occur
#' adjacent to each other more frequently than \code{min_cooc}.
#'
#' @param dat list of character vectors containing the fluency productions.
#' @param min_cooc integer specifying the minimum number of times two words
#'   are required to coocur one step apart from each other for an edge to
#'   connect those words.
#'
#' @return
#' A matrix
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Zemla, J. C., & Austerweil, J. L. (2018). Estimating semantic networks of
#' groups and individuals from fluency data. Computational Brain & Behavior,
#' 1-23.
#'
#' @examples
#'
#' # get animal fluency data
#' data(animal_fluency)
#'
#' # infer influence network
#' inferred_network = threshold_graph(animal_fluency)
#'
#' # Simulate -----
#'
#' # generate watts strogatz graph
#' network = grow_ws(n = 200, k = 10, p = .5)
#'
#' # generate fluency data
#' # sets string equal TRUE as community_graph expects mode character
#' fluency_data = fluency(get_adjlist(network), rep(10, 100), string = TRUE)
#'
#' # infer fluency network
#' inferred_network = threshold_graph(fluency_data)
#'
#' @export
threshold_graph <- function(dat, min_cooc = 2L) {
    .Call('_memnet_threshold_graph', PACKAGE = 'memnet', dat, min_cooc)
}

shuffle <- function(v) {
    .Call('_memnet_shuffle', PACKAGE = 'memnet', v)
}

seed <- function(n, m) {
    .Call('_memnet_seed', PACKAGE = 'memnet', n, m)
}

sm <- function(x) {
    .Call('_memnet_sm', PACKAGE = 'memnet', x)
}

getdegrees <- function(adj, pos) {
    .Call('_memnet_getdegrees', PACKAGE = 'memnet', adj, pos)
}

getnonneighbors <- function(adj, node) {
    .Call('_memnet_getnonneighbors', PACKAGE = 'memnet', adj, node)
}

randint <- function(n) {
    .Call('_memnet_randint', PACKAGE = 'memnet', n)
}

selectnode <- function(ps) {
    .Call('_memnet_selectnode', PACKAGE = 'memnet', ps)
}

selectnode_power <- function(ps, power) {
    .Call('_memnet_selectnode_power', PACKAGE = 'memnet', ps, power)
}

#' Steyvers and Tenenbaum (2004) network growth model
#'
#' Grow networks using Steyvers and Tenenbaum (2004) model, which combines
#' preferential attachment with a triad formation.
#'
#' @param n Integer. Number of nodes in the network.
#' @param m Integer. Number of edges added for each incoming node.
#'
#' @return n x n adjacency matrix.
#'
#' @references
#' Steyvers, M., & Tenenbaum, J. B. (2005). The large-scale structure of
#' semantic networks: Statistical analyses and a model of semantic growth.
#' Cognitive science, 29(1), 41-78.
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' @examples
#' # generate small graph
#' grow_st(n = 6, m = 2)
#'
#' \dontrun{
#' # generate large graph
#' grow_st(n = 100, m = 10)
#' }
#'
#' @export
grow_st <- function(n = 100L, m = 5L) {
    .Call('_memnet_grow_st', PACKAGE = 'memnet', n, m)
}

emptyseed <- function(n) {
    .Call('_memnet_emptyseed', PACKAGE = 'memnet', n)
}

puni <- function() {
    .Call('_memnet_puni', PACKAGE = 'memnet')
}

unconnectedneighbor <- function(adj, from, to) {
    .Call('_memnet_unconnectedneighbor', PACKAGE = 'memnet', adj, from, to)
}

#' Holme and Kim (2002) network growth model
#'
#' Grow networks using Holme & Kim's (2002) model, which combines preferential
#' attachment with tunable triad formation flexibly controlling the amount of
#' clustering in the network via \code{p}.
#'
#' @param n Integer. Number of nodes in the network.
#' @param m Integer. Number of edges added for each incoming node.
#' @param p Numeric. Proability that a triad formation step follows a preferential
#' attachment step.
#'
#' @return n x n adjacency matrix.
#'
#' @references
#' Holme, P., & Kim, B. J. (2002). Growing scale-free networks with tunable
#' clustering. Physical review E, 65(2), 026107.
#'
#' @examples
#' # generate small graph
#' grow_hk(n = 6, m = 2, p = .1)
#'
#' \dontrun{
#' # generate large graph, low clustering
#' grow_hk(n = 100, m = 10, p = .1)
#'
#' # generate large graph, high clustering
#' grow_hk(n = 100, m = 10, p = .9)
#' }
#'
#' @export
grow_hk <- function(n = 100L, m = 5L, p = 5) {
    .Call('_memnet_grow_hk', PACKAGE = 'memnet', n, m, p)
}

#' Barabási & Albert (2002) network growth model
#'
#' Grow networks using Barabási & Alberts's (2002) preferential
#' attachment model.
#'
#' @param n Integer. Number of nodes in the network.
#' @param m Integer. Number of edges added for each incoming node.
#' @param power Numeric. Controls the selection of nodes by raising the degree
#' to this power.
#'
#' @return n x n adjacency matrix.
#'
#' @references
#' Barabási, A. L., & Albert, R. (1999). Emergence of scaling in random
#' networks. Science, 286(5439), 509-512.
#'
#' @examples
#' # generate small graph
#' grow_ba(n = 6, m = 2)
#'
#' \dontrun{
#' # generate large graph, flat degree distribution
#' grow_ba(n = 100, m = 10, p = .1)
#'
#' # generate large graph, steep degree distribution
#' grow_ba(n = 100, m = 10, p = 10)
#' }
#'
#' @export
grow_ba <- function(n = 100L, m = 5L, power = 1) {
    .Call('_memnet_grow_ba', PACKAGE = 'memnet', n, m, power)
}

#' Watts & Strogatz (2002) network growth model
#'
#' Grow networks using Watts & Strogatz (1999) growth model, which constructs
#' in-between regular lattices and random networks by re-wiring edges of a
#' regular lattice with probability \code{p}.
#'
#' @param n Integer. Number of nodes in the network.
#' @param k Integer. Number of edges added for each incoming node. Can only be
#'   even.
#' @param p Numeric. Proability that an edge e_ij is rewired to e_ik with k being
#'   randomly drawn from the set of nodes.
#'
#' @return n x n adjacency matrix.
#'
#' @references
#' Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of ‘small-world’
#' networks. Nature, 393(6684), 440-442.
#'
#' @examples
#' # generate small, mildly random graph
#' grow_ws(n = 6, k = 2, p = .2)
#'
#' \dontrun{
#' # generate large, mildly random graph
#' grow_ws(n = 100, k = 10, p = .1)
#'
#' # generate large, highly random graph
#' grow_ws(n = 100, k = 10, p = 10)
#' }
#'
#' @export
grow_ws <- function(n = 100L, k = 10L, p = .2) {
    .Call('_memnet_grow_ws', PACKAGE = 'memnet', n, k, p)
}

#' Regular lattice network model
#'
#' Grow regular lattice networks, in which every node is connected to m neighbors.
#'
#' @inheritParams grow_ws
#'
#' @return n x n adjacency matrix.
#'
#' @references
#' Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of ‘small-world’
#' networks. Nature, 393(6684), 440-442.
#'
#' @examples
#' # generate small lattice
#' grow_lattice(n = 6, k = 2)
#'
#' \dontrun{
#' # generate large lattice
#' grow_lattice(n = 100, k = 10, p = .1)
#' }
#'
#' @export
grow_lattice <- function(n = 100L, k = 10L) {
    .Call('_memnet_grow_lattice', PACKAGE = 'memnet', n, k)
}

unique_int <- function(v) {
    .Call('_memnet_unique_int', PACKAGE = 'memnet', v)
}

runi <- function() {
    .Call('_memnet_runi', PACKAGE = 'memnet')
}

rint <- function(n) {
    .Call('_memnet_rint', PACKAGE = 'memnet', n)
}

#' Get adjacency list
#'
#' Get list containing adjacent, i.e., neighboring, nodes for each node in the
#' graph. Nodes are returned as their row indices of the adjacency matrix.
#'
#' @param adj numeric matrix specifying the adjacency matrix.
#'
#' @return A list of vectors containing the indices of adjacent nodes.
#'
#' @examples
#'
#' # generate watts strogatz graph
#' network = grow_ws(n = 6, k = 2, p = .5)
#'
#' # transform to adjlist
#' get_adjlist(network)
#'
#' @export
get_adjlist <- function(adj) {
    .Call('_memnet_get_adjlist', PACKAGE = 'memnet', adj)
}

#' Get neighbors \code{k} or fewer steps away
#'
#' Function iterates over graph to identify for a given node all nodes that are
#' no more than \code{k} steps apart.
#'
#' \code{k < 1} will be set to \code{k = 1}.
#'
#' @param adj numeric matrix specifying the adjacency matrix.
#' @param start integer specifying the row of the start node in the adjacency matrix.
#' @param k integer specifying the maximum distance to the start node.
#'
#' @return A numeric matrix of two columns containing nodes indices and the
#' geodesic distance to the start nodes of all nodes \code{k} or fewer steps
#' away from \code{start}.
#'
#' @examples
#'
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10, p = .5)
#'
#' # get neighborhood of second node
#' get_neighborhood(network, 2)
#'
#' # get 3-hop neighborhood of second node
#' get_neighborhood(network, 2, k = 3)
#'
#' @export
get_neighborhood <- function(adj, start, k = 1L) {
    .Call('_memnet_get_neighborhood', PACKAGE = 'memnet', adj, start, k)
}

#' Get vector of neighbors exactly k steps away
#'
#' Function iterates over graph to identify for a given node all nodes that are
#' exactly k steps apart.
#'
#' \code{k < 1} will be set to \code{k = 1}.
#'
#' @param adj numeric matrix specifying the adjacency matrix.
#' @param start integer specifying the row index of the start node in the
#'   adjacency matrix.
#' @param k integer specifying the exact distance to the start node.
#'
#' @return A numeric vector containing node indices of nodes \code{k} or fewer
#' steps away from \code{start}.
#' @examples
#'
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10, p = .5)
#'
#' # get neighborhood of second node
#' get_kneighbors(network, 2)
#'
#' # get 3-hop neighborhood of second node
#' get_kneighbors(network, 2, k = 3)
#'
#' @export
get_kneighbors <- function(adj, start, k = 1L) {
    .Call('_memnet_get_kneighbors', PACKAGE = 'memnet', adj, start, k)
}

prbs <- function(x, p) {
    .Call('_memnet_prbs', PACKAGE = 'memnet', x, p)
}

trm <- function(x, y) {
    .Call('_memnet_trm', PACKAGE = 'memnet', x, y)
}

get_names_c <- function(edg) {
    .Call('_memnet_get_names_c', PACKAGE = 'memnet', edg)
}

get_names_i <- function(edg) {
    .Call('_memnet_get_names_i', PACKAGE = 'memnet', edg)
}

noverk <- function(n, k) {
    .Call('_memnet_noverk', PACKAGE = 'memnet', n, k)
}

smpl <- function(ps) {
    .Call('_memnet_smpl', PACKAGE = 'memnet', ps)
}

my_to_string <- function(value) {
    .Call('_memnet_my_to_string', PACKAGE = 'memnet', value)
}

to_str <- function(items) {
    .Call('_memnet_to_str', PACKAGE = 'memnet', items)
}

getneighbors <- function(adjlist, pos) {
    .Call('_memnet_getneighbors', PACKAGE = 'memnet', adjlist, pos)
}

getnext <- function(neighbors) {
    .Call('_memnet_getnext', PACKAGE = 'memnet', neighbors)
}

unicut <- function(vs, n) {
    .Call('_memnet_unicut', PACKAGE = 'memnet', vs, n)
}

adjlist_minus1 <- function(adjlist) {
    .Call('_memnet_adjlist_minus1', PACKAGE = 'memnet', adjlist)
}

add_1 <- function(items) {
    invisible(.Call('_memnet_add_1', PACKAGE = 'memnet', items))
}

#' Verbal fluency generator
#'
#' Generates verbal fluency data using a switcher-random walk process.
#'
#' Function produces verbal fluency data via a switcher random walk
#' process that traverses the network by selecting a neighbor with
#' probability \code{1-pjump} or jumps to a random place in the network
#' with probability \code{pjump}. Where the random walk process enters
#' the network and where it jumps to is further controlled
#' by \code{type}. Neighbors are always selected uniformly.
#'
#' @param adj_list a list containing row indices of nodes adjacent node to the ith
#'   node as created by \link{get_adjlist}.
#' @param n integer specifying the number of unique productions.
#' @param pjump numeric specifying the probability of a jump.
#' @param type integer controlling network start and jump nodes.
#'   For \code{type = 0} the process selects the start node and any jump
#'   nodes proportional to their degree. For \code{type = 1} the process
#'   selects a random node to serve both as the start node and the jump node.
#'   For \code{type = 2} the process selects the start and any jump nodes
#'   uniformly at random.
#'
#' @return Integer vector containing the indices of the fluency productions.
#'   Indices refer to the row of the item in the original adjacency matrix. See
#'   \link{get_adjlist}.
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
#' Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
#' inspired mechanism for network exploration. International Journal of
#' Bifurcation and Chaos, 20(03), 913-922.
#'
#' @examples
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10)
#'
#' # create verbal fluency sequence
#' one_fluency(get_adjlist(network), 10)
#'
#' # create verbal fluency sequence
#' # with high jump probability
#' one_fluency(get_adjlist(network), 10, pjump = .5)
#'
#' @export
one_fluency <- function(adj_list, n, pjump = 0, type = 0L) {
    .Call('_memnet_one_fluency', PACKAGE = 'memnet', adj_list, n, pjump, type)
}

#' Repeated verbal fluency generator.
#'
#' Generates multiple verbal fluency sequences using \link{one_fluency}.
#'
#' For details see \link{one_fluency}.
#'
#' @inheritParams one_fluency
#' @param adjlist a list containing row indices of nodes adjacent node to the ith
#'   node as created by \link{get_adjlist}.
#' @param n integer vector specifying for each sequence the number of
#'   unique productions.
#' @param string logical specifying whether the output should be of mode character.
#'
#' @return List of character vectors containing the indices of the fluency productions.
#'   Indices refer to the row of the item in the original adjacency matrix. See
#'   \link{get_adjlist}.
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
#' Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
#' inspired mechanism for network exploration. International Journal of
#' Bifurcation and Chaos, 20(03), 913-922.
#'
#' @examples
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 3)
#'
#' # create verbal fluency sequences
#' fluency(get_adjlist(network), c(10, 10))
#'
#' # create verbal fluency sequence
#' # with high jump probability
#' fluency(get_adjlist(network), c(10, 10), pjump = .5)
#'
#' @export
fluency <- function(adjlist, n, pjump = 0, type = 0L, string = FALSE) {
    .Call('_memnet_fluency', PACKAGE = 'memnet', adjlist, n, pjump, type, string)
}

#' Fast verbal fluency generator
#'
#' Generates verbal fluency data using a switcher-random walk process.
#'
#' Function produces verbal fluency data via a switcher random walk
#' process that traverses the network by selecting a neighbor with
#' probability \code{1-pjump} or jumps to a random place in the network
#' with probability \code{pjump}. Where the random walk process enters
#' the network and where it jumps to is further controlled
#' by \code{type}. Neighbors are always selected uniformly.
#'
#' In contrast to \link{fluency}, this function does not check at every step
#' whether the sampled neighbor is already in the list of productions. Instead,
#' \code{ffluency} simply returns the list of unique productions. This means
#' that if repetitions occur \code{ffluency} will produce sequences of length
#' \code{min(n * 3 - k, n)} where k is the number of repeptitions.
#'
#' @inheritParams one_fluency
#' @param n integer specifying the maximum number of productions. Function may
#' return fewer than \code{n}.
#'
#' @return Integer vector containing the indices of the fluency productions.
#'   Indices refer to the row of the item in the original adjacency matrix. See
#'   \link{get_adjlist}.
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
#' Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
#' inspired mechanism for network exploration. International Journal of
#' Bifurcation and Chaos, 20(03), 913-922.
#'
#' @examples
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10)
#'
#' # create verbal fluency sequences
#' one_ffluency(get_adjlist(network),  10)
#'
#' # create verbal fluency sequence
#' # with high jump probability
#' one_ffluency(get_adjlist(network), 10, pjump = .5)
#'
#' @export
one_ffluency <- function(adj_list, n, pjump = 0, type = 0L) {
    .Call('_memnet_one_ffluency', PACKAGE = 'memnet', adj_list, n, pjump, type)
}

#' Fast verbal fluency generator
#'
#' Generates multiple verbal fluency sequences using \link{one_ffluency}.
#'
#' For details see \link{one_ffluency}.
#'
#' @inheritParams one_ffluency
#' @inheritParams fluency
#' @param n integer vector specifying for each sequence the maximum numbers of
#' productions. Function may return fewer than \code{n}.
#' @param string logical specifying whether the output should be of mode character.
#'
#' @return List of character vectors containing the indices of the fluency productions.
#'   Indices refer to the row of the item in the original adjacency matrix. See
#'   \link{get_adjlist}.
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
#' Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
#' inspired mechanism for network exploration. International Journal of
#' Bifurcation and Chaos, 20(03), 913-922.
#'
#' @examples
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10)
#'
#' # create verbal fluency sequences
#' ffluency(get_adjlist(network), c(10, 10))
#'
#' # create verbal fluency sequence
#' # with high jump probability
#' ffluency(get_adjlist(network), c(10, 10), pjump = .5)
#'
#' @export
ffluency <- function(adjlist, n, pjump = 0, type = 0L, string = FALSE) {
    .Call('_memnet_ffluency', PACKAGE = 'memnet', adjlist, n, pjump, type, string)
}

#' Verbal fluency step counter
#'
#' Generates verbal fluency data using a switcher-random walk process and counts
#' the number of steps required to produce \code{n} unique responses.
#'
#' Function produces verbal fluency data via a switcher random walk
#' process that traverses the network by selecting a neighbor with
#' probability \code{1-pjump} or jumps to a random place in the network
#' with probability \code{pjump}. Where the random walk process enters
#' the network and where it jumps to is further controlled
#' by \code{type}. Neighbors are always selected uniformly.
#'
#' In contrast to \link{fluency} and \code{ffluency}, returns the number of steps
#' required to produce a sequence of unique productions, rather than the
#' productions itself.
#'
#' @inheritParams one_fluency
#' @param n integer specifying the number of productions.
#'
#'
#' @return Integer vector containing the indices of the fluency productions.
#'   Indices refer to the row of the item in the original adjacency matrix. See
#'   \link{get_adjlist}.
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
#' Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
#' inspired mechanism for network exploration. International Journal of
#' Bifurcation and Chaos, 20(03), 913-922.
#'
#' @examples
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10)
#'
#' # count number of steps needed to create sequence
#' one_fluency_steps(get_adjlist(network), 10)
#'
#' # count number of steps needed to create sequence
#' # with high jump probability
#' one_fluency_steps(get_adjlist(network), 10, pjump = .5)
#'
#' @export
one_fluency_steps <- function(adj_list, n, pjump = 0, type = 0L) {
    .Call('_memnet_one_fluency_steps', PACKAGE = 'memnet', adj_list, n, pjump, type)
}

#' Verbal fluency step counter
#'
#' Repeatedly generates verbal fluency data using \link{one_fluency_steps} and
#' counts the number of steps required to produce \code{n} unique responses.
#'
#' For details see \link{one_fluency_steps}.
#'
#' @inheritParams one_fluency_steps
#' @inheritParams fluency
#' @param n integer vector specifying the numbers of production.
#'
#' @return List of character vectors containing the indices of the fluency productions.
#'   Indices refer to the row of the item in the original adjacency matrix. See
#'   \link{get_adjlist}.
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
#' Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
#' inspired mechanism for network exploration. International Journal of
#' Bifurcation and Chaos, 20(03), 913-922.
#'
#' @examples
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10)
#'
#' # count number of steps needed to create sequence
#' fluency_steps(get_adjlist(network), c(10, 10))
#'
#' # count number of steps needed to create sequence
#' # with high jump probability
#' fluency_steps(get_adjlist(network), c(10, 10), pjump = .5)
#'
#' @export
fluency_steps <- function(adjlist, n, pjump = 0, type = 0L) {
    .Call('_memnet_fluency_steps', PACKAGE = 'memnet', adjlist, n, pjump, type)
}

#' Search network using switcher-random walk process
#'
#' Traverses a network using a switcher-random walk process and records the
#' number of steps required to get from node \code{start} to node \code{observe}.
#'
#' If a node specified in \code{observe} has never been visited then the function
#' returns \code{nmax} for that node.
#'
#' @inheritParams one_fluency
#' @param start integer vector of length 1 specifying the index of
#'   the start node.
#' @param observe integer vector of length 1 or larger specifying the target
#'   end nodes.
#' @param nmax integer specifying the maximum number of steps before search
#'   terminates.
#'
#' @return Numeric, 3 column matrix containing in each row the start node, the
#' end node, and the (minimum) number of steps it took to reach the end node
#' from the start node.
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
#' Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
#' inspired mechanism for network exploration. International Journal of
#' Bifurcation and Chaos, 20(03), 913-922.
#'
#' @examples
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10)
#'
#' # observe number of steps from node 2
#' # to nodes 3, 4, and 5
#' one_search(get_adjlist(network), 2, c(3, 4, 5))
#'
#' # observe number of steps from node 2 to nodes 3, 4, and 5
#' # with high jump probability
#' one_search(get_adjlist(network), start = 2, observe = c(3, 4, 5), pjump = .5)
#'
#' @export
one_search <- function(adj_list, start, observe, nmax = 1000L, pjump = 0, type = 0L) {
    .Call('_memnet_one_search', PACKAGE = 'memnet', adj_list, start, observe, nmax, pjump, type)
}

#' Search network using switcher-random walk process
#'
#' Traverses a network using a switcher-random walk process and records the
#' number of steps required to get from node \code{start} to node \code{observe}.
#'
#' If a node specified in \code{observe} has never been visited then the function
#' returns \code{nmax} for that node.
#'
#' @inheritParams one_search
#' @inheritParams fluency
#' @param start integer vector of length 1 or larger specifying the index of
#'   the start node.
#' @param observe integer vector of length 1 or larger specifying the target
#'   end nodes.
#' @param nmax integer specifying the maximum number of steps before search
#'   terminates.
#'
#' @return Numeric, 3 column matrix containing in each row the start node, the
#' end node, and the (minimum) number of steps it took to reach the end node
#' from the start node.
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
#' Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
#' inspired mechanism for network exploration. International Journal of
#' Bifurcation and Chaos, 20(03), 913-922.
#'
#' @examples
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10)
#'
#' # observe number of steps from node 2 and 6
#' # to nodes 3, 4, and 5
#' search_rw(get_adjlist(network), c(2, 6), c(3, 4, 5))
#'
#' # observe number of steps from node 2 and 6 to nodes 3, 4, and 5
#' # with high jump probability
#' search_rw(get_adjlist(network), start = c(2, 6), observe = c(3, 4, 5), pjump = .5)
#'
#' @export
search_rw <- function(adjlist, start, observe, nmax = 1000L, pjump = 0, type = 0L) {
    .Call('_memnet_search_rw', PACKAGE = 'memnet', adjlist, start, observe, nmax, pjump, type)
}

#' Search network repeatedly using switcher-random walk process
#'
#' Traverses a network using a switcher-random walk process repeatedly, records
#' the earliest visit to nodes of interest and averages the result.
#'
#' Beginning at a given start node, function traverses a network using switcher
#' random walk and records for each of a list of nodes of interest the index at which
#' the respective nodes have been visited first.
#'
#' If a node specified in \code{observe} has never been visited then the function
#' returns \code{nmax} for that node.
#'
#' @inheritParams fluency
#' @inheritParams search_rw
#' @param observe integer vector specifying the nodes whose first visits should be recorded.
#' @param nmax integer specifying the maximum number of steps.
#' @param nrep integer specifying the number of iterations across which
#'   aggregates are computed.
#'
#' @return Numeric, 3 column matrix containing in each row the start node, the end node, and
#' the (minimum) number of steps it took to reach the end node from the start node.
#'
#' @references
#'
#' Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
#' differences in the semantic networks of younger and older adults.
#' https://doi.org/10.31234/osf.io/s73dp
#'
#' Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
#' Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
#' inspired mechanism for network exploration. International Journal of
#' Bifurcation and Chaos, 20(03), 913-922.
#'
#' @examples
#' # generate watts strogatz graph
#' network = grow_ws(n = 100, k = 10)
#'
#' # determine mean number of steps from node 2 and 6
#' # to nodes 3, 4, and 5
#' search_rw_mean(get_adjlist(network), c(2, 6), c(3, 4, 5))
#'
#' # determine mean number of steps from node 2 and 6 to nodes 3, 4, and 5
#' # with high jump probability
#' search_rw_mean(get_adjlist(network), start = c(2, 6), observe = c(3, 4, 5), pjump = .5)
#'
#' @export
search_rw_mean <- function(adjlist, start, observe, nmax = 1000L, pjump = 0, type = 0L, nrep = 100L) {
    .Call('_memnet_search_rw_mean', PACKAGE = 'memnet', adjlist, start, observe, nmax, pjump, type, nrep)
}

