% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{grow_lattice}
\alias{grow_lattice}
\title{Regular lattice network model}
\usage{
grow_lattice(n = 100L, k = 10L)
}
\arguments{
\item{n}{Integer. Number of nodes in the network.}

\item{k}{Integer. Number of edges added for each incoming node. Can only be
even.}
}
\value{
n x n adjacency matrix.
}
\description{
Grow regular lattice networks, in which every node is connected to m neighbors.
}
\examples{
# generate small lattice
grow_lattice(n = 6, k = 2)

\dontrun{
# generate large lattice
grow_lattice(n = 100, k = 10, p = .1)
}

}
\references{
Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of ‘small-world’
networks. Nature, 393(6684), 440-442.
}
