% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{hashmap}
\alias{hashmap}
\alias{[.hashmap}
\alias{[<-.hashmap}
\alias{[[.hashmap}
\alias{[[<-.hashmap}
\alias{keys}
\alias{values}
\alias{to_pairs}
\alias{from_pairs}
\alias{hasKey}
\alias{dropKey}
\title{A reference-valued, key-value store.}
\usage{
hashmap()

\method{[}{hashmap}(x, ...)

\method{[}{hashmap}(x, ...) <- value

\method{[[}{hashmap}(x, ...)

\method{[[}{hashmap}(x, ...) <- value

keys(x, ...)

values(x, ...)

to_pairs(x, ...)

from_pairs(pairs)

hasKey(x, ...)

dropKey(x, ...)
}
\arguments{
\item{x}{a hashmap object.}

\item{...}{Any number of indices.}

\item{value}{A replacement value for `[[`; for '[', a
sequence of replacement values.}

\item{pairs}{A list of pairs, the first element is treated as key
and the second as value.}
}
\value{
`hashmap()` returns a newly constructed hashmap.

`pairs(x)` extracts from a hashmap a list of pairs, each
  pair being of the form `list(key=, val=)`.

`hasKey(x)` returns TRUE if there is a key with the same
  digest as `...` that compares [identical()]
}
\description{
[hashmap()] constructs a hashmap, which is an object that behaves
like an [environment] but can key on arbitrary objects rather than
just characters.
}
\details{
You can use multiple indices in a hashmap; the effect is similar to
indexing on a list containing all keys.

Type is significant; for instance, float `1` and integer `1L` are
considered distinct indices. It is also permitted to index on NULL,
NA, or the empty string.

The `memo` package hashmap has a performance optimization over
other implementations of this concept, in that the md5 digest is
memoized on scalar and pointer values. That means that if you
lookup using keys that are pointer-identical to previously seen
keys, it will skip computing the digest a second time. Indexing
using scalar values will also bypass the md5 hash.
}
\author{
Peter Meilstrup
}
