% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_sim.R
\name{pb_sim}
\alias{pb_sim}
\title{Simulates persistence-break process}
\usage{
pb_sim(T, tau, trend = c("none", "linear"), tp = 1, d1, d2, mean, var)
}
\arguments{
\item{T}{length of the time series.}

\item{tau}{break fraction, \code{T*tau} yields the break point. It needs to hold that \code{0<tau<1}.}

\item{trend}{whether the time series exhibits a trend, \code{none} implies no trend and \code{linear} implies a linear trend.}

\item{tp}{trend parameter, \code{t*tp} yields the contribution of the trend component if \code{trend="linear"}.}

\item{d1}{order of integration of the first part of the series.}

\item{d2}{order of integration of the second part of the series.}

\item{mean}{mean of the series.}

\item{var}{variance of the innovations.}
}
\value{
Returns a vector containing the simulated time series.
}
\description{
This function simulates a process that exhibits a break in persistence.
}
\examples{
library(LongMemoryTS)
series<- pb_sim(500,0.5,"none",d1=0.2,d2=0.8,mean=0,var=1)
ts.plot(series)
}
\author{
Janis Becker
}
