% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resequence.R
\name{resequence}
\alias{resequence}
\title{Resorting and filtering dates}
\usage{
resequence(data, vars, unity = "\\\\.\\\\.")
}
\arguments{
\item{data}{a dataframe}

\item{vars}{a character vector identifying columns
in the dataframe to sequence}

\item{unity}{a string identifying how multiple
entries may be glued together.
By default, ".." are used in accordance with
ISO 8601-2_2019(E) standards.}
}
\value{
a dataframe/columns
}
\description{
Resorting and filtering dates
}
\examples{
data <- data.frame(Sign = c("2000-01-01", "2001-01-01",
"2001-01-01..2000-01-01", "2000-01-01", NA, "2016-12-31~"),
Force = c("2001-01-01", "2000-01-01",
"2001-01-01", NA, "2001-XX-XX", "~1816_01_01"))
resequence(data, c("Sign", "Force"))
}
