% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNearby.R
\name{getNearby}
\alias{getNearby}
\title{Filter environmental monitoring stations by POI}
\usage{
getNearby(siteID, lat, lon, radius, ...)
}
\arguments{
\item{siteID}{(character) in the form of: [NETWORK]:[ID]. Environmental monitoring network to use as your Point of Interest (POI). Required if \code{lat} & \code{lon} are missing.}

\item{lat}{(numeric) Latitude of (POI). \code{lat} and \code{lon} are required if \code{siteID} is missing.}

\item{lon}{(numeric) Longitude of POI. \code{lat} and \code{lon} are required if \code{siteID} is missing.}

\item{radius}{(numeric) Search radius outward from POI for finding environmental monitoring stations. Defined in kilometers (km); Required\cr}

\item{...}{auto-populates when called from \code{siteFinder()} wrapper}
}
\value{
A list comprising metadata of environmental monitoring stations located within \code{radius} from the user-entered \code{siteID} or \code{Lat}/\code{Lon} POI.
}
\description{
Return metadata of environmental monitoring stations nearby a specific environmental station (see \code{siteID}) or near a a Latitude/Longitude pair (see \code{lat,lon}).
}
\examples{
\dontrun{
#returns metadata from all sites within 50 km of NEON site 'CPER'
  getNearby(siteID="NEON:CPER", radius=50)
#return metadata of sites within 10 km of Lat=41.7821 & Lon = -71.4204 (Cranston, RI, USA)
  getNearby(lat=41.7821, lon = -71.4204, radius=10)}
}
\seealso{
\link[metScanR]{siteFinder}
\link[metScanR]{mapSiteFinder}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
}
\keyword{air}
\keyword{air,}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{canopy,}
\keyword{chemical,}
\keyword{climate,}
\keyword{cloud,}
\keyword{conductivity,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{flux,}
\keyword{groundwater,}
\keyword{humidity,}
\keyword{in-situ,}
\keyword{lake,}
\keyword{latitude,}
\keyword{longitude,}
\keyword{metadata}
\keyword{phenology,}
\keyword{pollution,}
\keyword{precipitation,}
\keyword{radiation,}
\keyword{radius,}
\keyword{reservoir,}
\keyword{river,}
\keyword{salinity,}
\keyword{snow,}
\keyword{soil,}
\keyword{soils,}
\keyword{stream,}
\keyword{temperature,}
\keyword{vapor,}
\keyword{water,}
\keyword{weather,}
\keyword{wind,}
