% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drapery.R
\name{drapery}
\alias{drapery}
\title{Drapery plot}
\usage{
drapery(
  x,
  type = "zvalue",
  layout = "grayscale",
  study.results = TRUE,
  lty.study = 1,
  lwd.study = 1,
  col.study = "darkgray",
  labels,
  col.labels = "black",
  cex.labels = 0.7,
  subset.labels,
  srt.labels,
  fixed = x$fixed,
  random = x$random,
  lty.fixed = 1,
  lwd.fixed = max(3, lwd.study),
  col.fixed = "blue",
  lty.random = 1,
  lwd.random = lwd.fixed,
  col.random = "red",
  sign = NULL,
  lty.sign = 1,
  lwd.sign = 1,
  col.sign = "black",
  prediction = random,
  col.predict = "lightblue",
  alpha = if (type == "zvalue") c(0.001, 0.01, 0.05, 0.1) else c(0.01, 0.05, 0.1),
  lty.alpha = 2,
  lwd.alpha = 1,
  col.alpha = "black",
  cex.alpha = 0.7,
  col.null.effect = "black",
  legend = TRUE,
  pos.legend = "topleft",
  bg = "white",
  bty = "o",
  backtransf = x$backtransf,
  xlab,
  ylab,
  xlim,
  ylim,
  lwd.max = 2.5,
  lwd.study.weight = if (random) "random" else "fixed",
  at = NULL,
  n.grid = if (type == "zvalue") 10000 else 1000,
  mar = c(5.1, 4.1, 4.1, 4.1),
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{meta}.}

\item{type}{A character string indicating whether to plot test
statistics (\code{"zvalue"}) or p-values (\code{"pvalue"}), can
be abbreviated.}

\item{layout}{A character string for the line layout of individual
studies: \code{"grayscale"}, \code{"equal"}, or
\code{"linewidth"} (see Details), can be abbreviated.}

\item{study.results}{A logical indicating whether results for
individual studies should be shown in the figure.}

\item{lty.study}{Line type for individual studies.}

\item{lwd.study}{Line width for individual studies.}

\item{col.study}{Colour of lines for individual studies.}

\item{labels}{A logical or character string indicating whether
study labels should be shown at the top of the drapery plot;
either \code{FALSE}, \code{"id"}, or \code{"studlab"}; see
Details.}

\item{col.labels}{Colour of study labels.}

\item{cex.labels}{The magnification for study labels.}

\item{subset.labels}{A vector specifying which study labels should
be shown in the drapery plot.}

\item{srt.labels}{A numerical vector or single numeric (between 0
and 90) specifying the angle to rotate study labels; see Details.}

\item{fixed}{A logical indicating whether to show result for the
fixed effect / common effect model.}

\item{random}{A logical indicating whether to show result for the
random effects model.}

\item{lty.fixed}{Line type for fixed effect meta-analysis.}

\item{lwd.fixed}{Line width for fixed effect meta-analysis.}

\item{col.fixed}{Colour of lines for fixed effect meta-analysis.}

\item{lty.random}{Line type for random effects meta-analysis.}

\item{lwd.random}{Line width for random effects meta-analysis.}

\item{col.random}{Colour of lines for random effects meta-analysis.}

\item{sign}{Significance level used to highlight significant values
in curves.}

\item{lty.sign}{Line type for significant values.}

\item{lwd.sign}{Line width for significant values.}

\item{col.sign}{Line colour for significant values.}

\item{prediction}{A logical indicating whether to show prediction
region.}

\item{col.predict}{Colour of prediction region}

\item{alpha}{Horizonal lines are printed for the specified alpha
values.}

\item{lty.alpha}{Line type of horizonal lines for alpha values.}

\item{lwd.alpha}{Line width of horizonal lines for alpha values.}

\item{col.alpha}{Colour of horizonal lines for alpha values.}

\item{cex.alpha}{The magnification for the text of the alpha}

\item{col.null.effect}{Colour of vertical line indicating null
effect.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{pos.legend}{A character string with position of legend (see
\code{\link{legend}}).}

\item{bg}{Background colour of legend (see \code{\link{legend}}).}

\item{bty}{Type of the box around the legend; either \code{"o"} or
\code{"n"} (see \code{\link{legend}}).}

\item{backtransf}{A logical indicating whether results should be
back transformed on the x-axis. For example, if \code{backtransf
= FALSE}, log odds ratios instead of odds ratios are shown on the
x-axis.}

\item{xlab}{A label for the x-axis.}

\item{ylab}{A label for the y-axis.}

\item{xlim}{The x limits (min, max) of the plot.}

\item{ylim}{The y limits (min, max) of the plot (ignored if
\code{type = "pvalue"}).}

\item{lwd.max}{The maximum line width (only considered if argument
\code{layout} is equal to \code{"linewidth"}).}

\item{lwd.study.weight}{A character string indicating whether to
determine line width for individual studies using weights from
fixed effect (\code{"fixed"}) or random effects model
(\code{"random"}), can be abbreviated (only considered if
argument \code{layout} is equal to \code{"linewidth"}).}

\item{at}{Points at which tick-marks are to be drawn on the x-axis.}

\item{n.grid}{The number of grid points to calculate the p-value or
test statistic functions.}

\item{mar}{Physical plot margin, see \code{\link{par}}.}

\item{plot}{A logical indicating whether to generate a figure.}

\item{\dots}{Graphical arguments as in \code{par} may also be
passed as arguments.}
}
\description{
Draw a drapery plot with (scaled) p-value curves for individual
studies and meta-analysis estimates.
}
\details{
The concept of a p-value function, also called confidence curve,
goes back to Birnbaum (1961). A drapery plot, showing p-value
functions (or a scaled version based on the corresponding test
statistics) for individual studies as well as meta-analysis
estimates, is drawn in the active graphics window. Furthermore, a
prediction region for a single future study is shown as a shaded
area. In contrast to a forest plot, a drapery plot does not provide
information for a single confidence level however for any
confidence level.

Argument \code{type} can be used to either show p-value functions
(Birnbaum, 1961) or a scaled version (Infanger, 2019) with test
statistics (default).

Argument \code{layout} determines how curves for individual studies
are presented:
\itemize{
\item darker gray tones with increasing precision (\code{layout =
  "grayscale"})
\item thicker lines with increasing precision (\code{layout =
  "linewidth"})
\item equal lines (\code{layout = "equal"})
}

Argument \code{labels} determines how curves of individual studies
are labelled:
\itemize{
\item number of the study in the (unsorted) forest plot / printout
  of a meta-analysis (\code{labels = "id"})
\item study labels provided by argument \code{studlab} in
  meta-analysis functions (\code{labels = "studlab"})
\item no study labels (\code{labels = FALSE})
}
By default, study labels are used (\code{labels = "studlab"}) if no
label has more than three characters; otherwise IDs are used
(\code{labels = "id"}). The connection between IDs and study labels
(among other information) is part of a data frame which is
invisibly returned (if argument \code{ study.results = TRUE}).

Argument \code{srt.labels} can be used to change the rotation of
IDs or study labels. By default, study labels are rotated by +/- 45
degrees if at least one study label has more than three characters;
otherwise labels are not rotated.

If \code{labels = "studlab"}, labels are rotated by -45 degrees for
studies with a treatment estimate below the fixed effect estimate
and otherwise by 45 degrees.
}
\examples{
data("lungcancer")
m1 <- metainc(d.smokers, py.smokers, d.nonsmokers, py.nonsmokers,
  data = lungcancer, studlab = study)

# Drapery plot
#
drapery(m1, xlim = c(0.5, 50))

\dontrun{
data(Fleiss1993bin)
m2 <- metabin(d.asp, n.asp, d.plac, n.plac,
  data = Fleiss1993bin, studlab = paste(study, year),
  sm = "OR", random = FALSE)

# Produce drapery plot and print data frame with connection between
# IDs and study labels
#
(drapery(m2))

# For studies with a significant effect (p < 0.05), show
# study labels and print labels and lines in red
#
drapery(m2,
  labels = "studlab", subset.labels = pval < 0.05,
  srt.labels = 0, col.labels = "red",
  col.study = ifelse(pval < 0.05, "red", "darkgray"))
}

}
\references{
Birnbaum A (1961):
Confidence Curves: An Omnibus Technique for Estimation and Testing
Statistical Hypotheses.
\emph{Journal of the American Statistical Association},
\bold{56}, 246--9

Infanger D and Schmidt-Trucksäss A (2019):
P value functions: An underused method to present research results
and to promote quantitative reasoning
\emph{Statistics in Medicine},
\bold{38}, 4189--97
}
\seealso{
\code{\link{forest}}, \code{\link{radial}}
}
\author{
Gerta Rücker \email{sc@imbi.uni-freiburg.de}, Guido
  Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{hplot}
