% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal.R
\name{negative_exponential_function}
\alias{negative_exponential_function}
\title{Negative Exponential kernel}
\usage{
negative_exponential_function(x, mean_dispersal_dist)
}
\arguments{
\item{x}{\verb{<numeric>} distance at which the probability is calculated.}

\item{mean_dispersal_dist}{\verb{<numeric>} mean dispersal distance (>0)}
}
\value{
\verb{<numeric>} The probability at distance x.
}
\description{
Negative Exponential kernel
}
\details{
The negative exponential kernel is defined as:
\deqn{f(x) = \frac{1}{2 \pi a^2} e^{-\frac{x}{a}}}{fx = 1 / (2 * pi * a^2) * exp(-x / a)}
where \eqn{a} is the mean dispersal distance divided by 2.
}
\examples{
negative_exponential_function(1, 1)
}
\references{
Nathan, R., Klein, E., Robledo-Arnuncio, J.J. and Revilla, E. (2012)
Dispersal kernels: review.
in: \emph{Dispersal Ecology and Evolution} pp. 187--210.
(eds J. Clobert, M. Baguette, T.G. Benton and J.M. Bullock),
Oxford, UK: Oxford Academic, 2013.
\doi{10.1093/acprof:oso/9780199608898.003.0015}
}
