% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_species.r
\name{save_species}
\alias{save_species}
\title{Save function}
\usage{
save_species(x, traits = NULL, prefix = NULL, path, overwrite = FALSE, ...)
}
\arguments{
\item{x}{\verb{<metaRangeSpecies>} \link{metaRangeSpecies} object.}

\item{traits}{\verb{<character>} NULL or a character vector specifying the trait to save.
If NULL, all traits are saved.}

\item{prefix}{\verb{<string>} prefix for the file names or NULL.}

\item{path}{\verb{<string>}path to the directory where the files are saved.}

\item{overwrite}{\verb{<boolean>} overwrite existing files.}

\item{...}{additional arguments passed to \link[terra:writeRaster]{terra::writeRaster}.}
}
\value{
\verb{<invisible character>} the paths to the saved files.
}
\description{
Saves the specified traits of a \link{metaRangeSpecies} object.
}
\details{
The generated file names are of the form
\code{file.path(path, paste0(prefix, species_name, "_", trait_name, ".file_extension"))}.
If the trait is in a matrix or raster form, the file extension is \code{.tif}. Otherwise it is \code{.csv}.
The prefix is optional and mainly useful to add a time step to the file name, in case the trait
is saved multiple times during a simulation.
}
\examples{
sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2))
names(sim_env) <- "env_01"
test_sim <- metaRangeSimulation$new(source_environment = sim_env)
test_sim$add_species("species_01")
test_sim$add_traits(
    "species_01",
    trait_01 = matrix(1, nrow = 2, ncol = 2),
    trait_02 = matrix(2, nrow = 2, ncol = 2)
)

file_prefix <- "This_could_be_a_time_step"
directory_name <- tempdir()

res_path <- save_species(
    test_sim$species_01,
    traits = "trait_01",
    prefix = file_prefix,
    path = directory_name
)
# the following should be TRUE
# but might fail due to floating point errors (that's why we round the values)
identical(
    round(terra::as.matrix(terra::rast(res_path), wide = TRUE)),
    round(test_sim$species_01$traits[["trait_01"]])
)

# test overwrite
res_path2 <- save_species(
    test_sim$species_01,
    traits = "trait_01",
    prefix = file_prefix,
    path = directory_name,
    overwrite = TRUE
)
stopifnot(identical(res_path, res_path2))

# Saving all traits
res_path3 <- save_species(
    test_sim$species_01,
    prefix = basename(tempfile()),
    path = directory_name
)
res_path3
# cleanup
unlink(c(res_path, res_path3))
stopifnot(all(!file.exists(res_path, res_path3)))
}
