% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submnet.R
\name{bestRanking}
\alias{bestRanking}
\title{Identify the best ranking}
\usage{
bestRanking(fns)
}
\arguments{
\item{fns}{List of fitness objects.}
}
\value{
The performance indices for all rankings and the best ranking.
}
\description{
This function computes the performance indices of different rankings compared to the random ranking for gene removal and identify the best ranking
}
\examples{
data(Ec_core)
mod <- rescue(Ec_core, target=0.1)
mod.weight <- changeObjFunc(mod$rescue, react=rownames(mod$coef), obj_coef=mod$coef)
ranks <- list(
   rep.1=data.frame(
       expr=setNames(rnorm(length(sybil::allGenes(mod.weight)), mean=5, sd=4),
           sybil::allGenes(mod.weight))),
   rep.2=data.frame(
       expr=setNames(rnorm(length(sybil::allGenes(mod.weight)), mean=5, sd=4.1),
           sybil::allGenes(mod.weight))))
fn <- fitness(model=mod.weight, ranks=ranks, step=200, draw.num=1)
bestRanking(list(fn))
}
