% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_small_study_effects}
\alias{plot_small_study_effects}
\title{Plot small-study effects analysis}
\usage{
plot_small_study_effects(x, save = FALSE, path, format = ".png")
}
\arguments{
\item{x}{an object of class meta}

\item{save}{A boolean to indicate whether to save the plot to disk.}

\item{path}{Path to write to. It has to be a character string indicating the path and file name (without the extension). For example, \verb{~/Documents/small_study_effects} will save \code{small_study_effects.png} to the \code{Documents} folder.}

\item{format}{The file extension that you want to save the plot to. Only \code{.png}, is supported.}
}
\value{
a plot.
}
\description{
Plot small-study effects analysis
}
\examples{
\dontrun{
  # Perform meta-analysis on VO2max
  results <- perform_meta(endpoint = "VO2max")

  # Plot small-study effects results
  results$meta_analysis$Overall \%>\%
     plot_small_study_effects()
}
}
