% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{nearestQC_norm}
\alias{nearestQC_norm}
\title{nearest QC sample normalization}
\usage{
nearestQC_norm(
  object,
  n_nearest_QCsample = 3,
  feature_platform = "PLATFORM",
  QC_ID_pattern = "MTRX",
  test = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{A Metabolite object. In the feature annotation slot `feature`, a platform column should be provided for metabolite measurement platform (eg. `PLATFORM`). The values in the `PLATFORM` column (eg. `Neg`, `Polar`, `Pos Early`, and `Pos Late`) are column names in the sample annotation `sample` to determine the batches of samples.}

\item{n_nearest_QCsample}{Number of nearest QC samples to calculate the median value. The default value is 3 (an outlier QC sample might be used if only n_nearest_QCsample = 1).}

\item{feature_platform}{The column name of feature platform for metabolite measurements (eg. `PLATFORM`).}

\item{QC_ID_pattern}{A character pattern to determine QC samples. Default value: "MTRX".}

\item{test}{test the function for the first 20 columns.}

\item{verbose}{print log information.}
}
\value{
A Metabolite object after normalization.
}
\description{
Normalization data by the median value of the nearest QC samples. For each metabolite, the values (eg. raw peak area data) were divided by the median value of nearest QC samples (eg. the nearest three QC samples). To identify the nearest QC samples, `@assayData` should be ordered by the injection order.
}
\seealso{
\code{\link{batch_norm}}, \code{\link{QCmatrix_norm}}
}
