% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{run_PCA}
\alias{run_PCA}
\title{Principal Components Analysis}
\usage{
run_PCA(
  object,
  nPCs = 10,
  impute_method = "half-min",
  log = TRUE,
  scale = TRUE,
  addPC = TRUE
)
}
\arguments{
\item{object}{A Metabolite object.}

\item{nPCs}{Number of principal components to be calculated. Default value 10.}

\item{impute_method}{Imputation method, the default method is half the minimum value (`half-min`) of the metabolite. Currently support 'half-min', "median", "mean", "zero". `NULL` without imputation.}

\item{log}{Performs natural logarithm transformation before PCA analysis.}

\item{scale}{scale feature in the PCA calculation.}

\item{addPC}{If TRUE, merge PCs with `@sampleData` and return the `object`, else return `PC`.}
}
\value{
A list of PCs  and variances explained.
}
\description{
Performs a principal components analysis on the Metabolite object.
}
\examples{
data(df_plasma)
d <- run_PCA(df_plasma)

}
