% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations--internal.R
\name{get_numeric_cols}
\alias{get_numeric_cols}
\title{Get numeric columns from taxmap table}
\usage{
get_numeric_cols(obj, dataset, cols = NULL)
}
\arguments{
\item{obj}{A taxmap object}

\item{dataset}{The name of a table in \code{obj}.}

\item{cols}{The names/indexes of columns in \code{dataset} to use. By
default, all numeric columns are used. Takes one of the following inputs:
\describe{
  \item{TRUE/FALSE:}{All/No columns will used.}
  \item{Character vector:}{The names of columns to use}
  \item{Numeric vector:}{The indexes of columns to use}
  \item{Vector of TRUE/FALSE of length equal to the number of columns:}{Use the columns
corresponding to \code{TRUE} values.}
}}
}
\description{
If columns are specified by the user, parse them and check that they are numeric.
If not, return all numeric columns.
}
\keyword{internal}
