% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writers.R
\name{write_unite_general}
\alias{write_unite_general}
\title{Write an imitation of the UNITE general FASTA database}
\usage{
write_unite_general(obj, file,
  tax_names = obj$get_data("taxon_names")[[1]],
  ranks = obj$get_data("unite_rank")[[1]],
  sequences = obj$get_data("unite_seq")[[1]],
  seq_name = obj$get_data("organism")[[1]],
  ids = obj$get_data("unite_id")[[1]],
  gb_acc = obj$get_data("acc_num")[[1]],
  type = obj$get_data("unite_type")[[1]])
}
\arguments{
\item{obj}{A taxmap object}

\item{file}{(\code{character} of length 1) The file path to save the
sequence fasta file. This is optional.}

\item{tax_names}{(\code{character} named by taxon ids) The names of taxa}

\item{ranks}{(\code{character} named by taxon ids) The ranks of taxa}

\item{sequences}{(\code{character} named by taxon ids) Sequences}

\item{seq_name}{(\code{character} named by taxon ids) Name of sequences.
Usually a taxon name.}

\item{ids}{(\code{character} named by taxon ids) UNITE sequence ids}

\item{gb_acc}{(\code{character} named by taxon ids) Genbank accession
numbers}

\item{type}{(\code{character} named by taxon ids) What type of sequence it
is. Usually "rep" or "ref".}
}
\description{
Attempts to save taxonomic and sequence information of a taxmap object in the
UNITE general FASTA format. If the taxmap object was created using
\code{\link{parse_unite_general}}, then it should be able to replicate the format
exactly with the default settings.
}
\details{
The output file has a format like:

\preformatted{
>Glomeromycota_sp|KJ484724|SH523877.07FU|reps|k__Fungi;p__Glomeromycota;c__unid...
ATAATTTGCCGAACCTAGCGTTAGCGCGAGGTTCTGCGATCAACACTTATATTTAAAACCCAACTCTTAAATTTTGTAT...
...
}
}
\seealso{
Other writers: \code{\link{write_greengenes}},
  \code{\link{write_mothur_taxonomy}},
  \code{\link{write_rdp}}
}
\concept{writers}
