% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_ambiguous.R
\name{ambiguous_patterns}
\alias{ambiguous_patterns}
\title{Get patterns for ambiguous taxa}
\usage{
ambiguous_patterns(
  unknown = TRUE,
  uncultured = TRUE,
  case_variations = FALSE,
  whole_match = FALSE,
  name_regex = "."
)
}
\arguments{
\item{unknown}{If \code{TRUE}, Remove taxa with names the suggest they are
placeholders for unknown taxa (e.g. "unknown ...").}

\item{uncultured}{If \code{TRUE}, Remove taxa with names the suggest they are
assigned to uncultured organisms (e.g. "uncultured ...").}

\item{case_variations}{If \code{TRUE}, include variations of letter case.}

\item{whole_match}{If \code{TRUE}, add "^" to front and "$" to the back of each
pattern to indicate they are to match whole words.}

\item{name_regex}{The regex code to match a valid character in a taxon name.
For example, "[a-z]" would mean taxon names can only be lower case letters.}
}
\description{
This function stores the regex patterns for ambiguous taxa.
}
\keyword{internal}
