% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxmap--docs.R
\name{obs}
\alias{obs}
\title{Get data indexes associated with taxa}
\arguments{
\item{obj}{([taxmap()]) The [taxmap()] object containing taxon information to
be queried.}

\item{data}{Either the name of something in `obj$data` that has taxon
information or a an external object with taxon information. For tables,
there must be a column named "taxon_id" and lists/vectors must be named by
taxon ID.}

\item{value}{What data to return. This is usually the name of column in a
table in `obj$data`. Any result of `all_names(obj)` can be used. If the
value used has names, it is assumed that the names are taxon ids and the
taxon ids are used to look up the correct values.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to find observations
for. Default: All taxa in `obj` will be used. Any variable name that
appears in [all_names()] can be used as if it was a vector on its own.}

\item{recursive}{(`logical` or `numeric`) If `FALSE`, only return the
observation assigned to the specified input taxa, not subtaxa. If `TRUE`,
return all the observations of every subtaxa, etc. Positive numbers
indicate the number of ranks below the each taxon to get observations for
`0` is equivalent to `FALSE`. Negative numbers are equivalent to `TRUE`.}

\item{simplify}{(`logical`) If `TRUE`, then combine all the results into a
single vector of unique observation indexes.}
}
\value{
If `simplify = FALSE`, then a list of vectors of observation indexes
  are returned corresponding to the `data` argument. If `simplify = TRUE`,
  then the observation indexes for all `data` taxa are returned in a single
  vector.
}
\description{
Given a [taxmap()] object, return data associated with each taxon in a
given table included in that [taxmap()] object.
\preformatted{
obj$obs(data, value = NULL, subset = NULL,
  recursive = TRUE, simplify = FALSE)
obs(obj, data, value = NULL, subset = NULL,
  recursive = TRUE, simplify = FALSE)}
}
\examples{
# Get indexes of rows corresponding to each taxon
obs(ex_taxmap, "info")

# Get only a subset of taxon indexes
obs(ex_taxmap, "info", subset = 1:2)

# Get only a subset of taxon IDs
obs(ex_taxmap, "info", subset = c("b", "c"))

# Get only a subset of taxa using logical tests
obs(ex_taxmap, "info", subset = taxon_ranks == "genus")

# Only return indexes of rows assinged to each taxon explicitly
obs(ex_taxmap, "info", recursive = FALSE)

# Lump all row indexes in a single vector
obs(ex_taxmap, "info", simplify = TRUE)

# Return values from a dataset instead of indexes
obs(ex_taxmap, "info", value = "name")

}
