% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/random_OR.R
\name{random_OR}
\alias{random_OR}
\title{Random generation of odds ratio (OR) effect sizes.}
\usage{
random_OR(K, p_A, N_A, p_B, N_B, continuity = 0.5, logged = TRUE)
}
\arguments{
\item{K}{Number of effect sizes to generate.}

\item{p_A}{The odds of the event of interest for Group A.  A probability
ranging from zero to one.}

\item{N_A}{The total number of samples of Group A.}

\item{p_B}{The odds of the event of interest for Group B.  A probability
ranging from zero to one.}

\item{N_B}{The total number of samples of Group B.}

\item{continuity}{Odds ratios with zero events cannot be computed.  Following,
Cox (1970), a continuity correction can be added to each cell of the 2 by 2
table to help improve this problem of zero events within the table.  The
default value added is 0.5.}

\item{logged}{When \code{"FALSE"}, returns non-logged transformed
   odds ratios and appropriate variances.  Default is TRUE.}
}
\value{
A data table with columns of random effect sizes (OR) and their
   variances.
}
\description{
Generates random odds ratios, logged odds ratios, and their
variances (Cornfield 1951).
}
\examples{
random_OR(K = 5, p_A = 0.3, N_A = 100, p_B = 0.1, N_B = 60)
}
\references{
Cornfield, J. 1951. A method for estimating comparative rates
   from Clinical Data. Applications to cancer of the lung, breast, and cervix.
   Journal of the National Cancer Institute 11: 1269-1275.

Cox, D.R. 1970. The continuity correction. Biometrika 57: 217-219.
}

