% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_N.R
\name{random_N}
\alias{random_N}
\title{Random generation of sample sizes (N) for study outcomes.}
\usage{
random_N(K, method = "NegativeBinomial", mean = 15, min = 3, NB_size = 15)
}
\arguments{
\item{K}{Number of sample sizes to generate.}

\item{method}{A string that defines what sampling distribution to generate
random N.  The default is \code{"NegativeBinomial"} but a \code{"Poisson"} 
distribution can also be used.}

\item{mean}{The population mean (mu) if \code{"NegativeBinomial"}, or the lambda 
(dispersion parameter) if \code{"Poisson"}.  The default is 15, which will 
generate sample sizes that on average will center around N = 15.}

\item{min}{A non-negative integer that specifies the minimum sample size that
can be generated.  Default is N = 3.}

\item{NB_size}{Dispersion parameter for the \code{"Negative Binomial"} distribution
that must be strictly positive, but need not be integer.  Default is 15, 
which creates a long tail for random N's ranging to about N = 60.  Increase
value to create a longer tail of random sample sizes.}
}
\value{
A vector of random sample sizes (N).
}
\description{
Generates random sample sizes (N) by either sampling from a Negative Binomial 
   or Poisson distribution.
}
