% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define.R
\name{define_parameter}
\alias{define_parameter}
\title{Define analysis parameter meta information for ADaM dataset}
\usage{
define_parameter(meta, name, subset = NULL, ...)
}
\arguments{
\item{meta}{A \code{meta_adam} object.}

\item{name}{A character value of term name.
The term name is used as key to link information.}

\item{subset}{An expression to identify analysis records.
See \code{\link[base:subset]{base::subset()}}.}

\item{...}{Additional variables.}
}
\value{
A metadata object with parameters defined.
}
\description{
Define analysis parameter meta information for ADaM dataset
}
\examples{
plan <- plan(
  analysis = "ae_summary", population = "apat",
  observation = c("wk12", "wk24"), parameter = "any;rel;ser"
)

meta_adam(
  population = r2rtf::r2rtf_adsl,
  observation = r2rtf::r2rtf_adae
) |>
  define_plan(plan = plan) |>
  define_parameter(
    name = "rel",
    subset = AEREL \%in\% c("POSSIBLE", "PROBABLE")
  )
}
