% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utils.r
\name{forest}
\alias{forest}
\title{Forest plot}
\usage{
forest(theta, theta.ci, theta.slab, theta.summary, theta.summary.ci,
  theta.summary.pi = c(NA, NA), title, sort = "asc", theme = theme_bw(),
  predint.linetype = 1, xlim, xlab = "", refline = 0,
  label.summary = "Summary Estimate", ...)
}
\arguments{
\item{theta}{Numeric vector with effect size for each study}

\item{theta.ci}{Two-dimensional array specifying the lower bound (first column) and upper bound (second column) of the 
confidence interval of the effect sizes}

\item{theta.slab}{Character vector specifying the study labels}

\item{theta.summary}{Meta-analysis summary estimate of the effect sizes}

\item{theta.summary.ci}{Numeric vector specifying the lower bound (first item) and upper bound (second item) of the 
confidence interval of the summary estimate}

\item{theta.summary.pi}{Numeric vector specifying the lower bound (first item) and upper bound (second item) of the 
prediction interval of the summary estimate.}

\item{title}{Title of the forest plot}

\item{sort}{By default, studies are sorted by ascending effect size (\code{sort="asc"}). Set to \code{"desc"} for 
sorting in reverse order, or any other value to ignore sorting.}

\item{theme}{Theme to generate the forest plot. By default, the classic dark-on-light ggplot2 theme is used. 
See \link[ggplot2]{theme_bw} for more information.}

\item{predint.linetype}{The linetype of the prediction interval}

\item{xlim}{The \code{x} limits \code{(x1, x2)} of the forest plot}

\item{xlab}{Optional character string specifying the X label}

\item{refline}{Optional numeric specifying a reference line}

\item{label.summary}{Optional character string specifying the label for the summary estimate}

\item{\dots}{Additional arguments, which are currently ignored.}
}
\description{
Generate a forest plot by specifying the various effect sizes, confidence intervals and summary estimate.
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
