% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_ind.R
\name{anova_ind}
\alias{anova_ind}
\title{Within-environment analysis of variance}
\usage{
anova_ind(.data, env, gen, rep, resp, block = NULL, verbose = TRUE)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments. The analysis of variance is computed for each level of this
factor.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{rep}{The name of the column that contains the levels of the
replications/blocks.}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure a vector of variables may be used. For example \code{resp = c(var1, var2, var3)}.}

\item{block}{Defaults to \code{NULL}. In this case, a randomized complete
block design is considered. If block is informed, then a resolvable
alpha-lattice design (Patterson and Williams, 1976) is employed.
\strong{All effects, except the error, are assumed to be fixed.}}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}
}
\value{
A list where each element is the result for one variable containing
(1) \strong{individual}: A tidy tbl_df with the results of the individual
analysis of variance with the following column names, and (2) \strong{MSRatio}:
The ratio between the higher and lower residual mean square. The following
columns are returned, depending on the experimental design
\itemize{
\item \strong{For analysis in alpha-lattice designs}:
\itemize{
\item \code{MEAN}: The grand mean.
\item \verb{DFG, DFCR, and DFIB_R, and DFE}: The degree of freedom for genotype,
complete replicates, incomplete blocks within replicates, and error,
respectively.
\item \verb{MSG, MSCR, MSIB_R}: The mean squares for genotype, replicates, incomplete
blocks within replicates, and error, respectively.
\item \verb{FCG, FCR, FCIB_R}: The F-calculated for genotype, replicates and
incomplete blocks within replicates, respectively.
\item \verb{PFG, PFCR, PFIB_R}: The P-values for genotype, replicates and incomplete
blocks within replicates, respectively.
\item \code{CV}: coefficient of variation.
\item \code{h2}: broad-sense heritability.
\item \code{AS}: accuracy of selection (square root of \code{h2})
}
\item \strong{For analysis in randomized complete block design}:
\itemize{
\item \code{MEAN}: The grand mean.
\item \verb{DFG, DFB, and DFE}: The degree of freedom for genotype blocks, and error, respectively.
\item \verb{MSG, MSB, and MSE}: The mean squares for genotype blocks, and error, respectively.
\item \verb{FCG and FCB}: The F-calculated for genotype and blocks, respectively.
\item \verb{PFG and PFB}: The P-values for genotype and blocks, respectively.
\item \code{CV}: coefficient of variation.
\item \code{h2}: broad-sense heritability.
\item \code{AS}: accuracy of selection (square root of \code{h2})
}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Performs a within-environment analysis of variance in randomized complete
block or alpha-lattice designs and returns values such as Mean Squares,
p-values, coefficient of variation, heritability, and accuracy of selection.
}
\examples{
\donttest{
library(metan)
# ANOVA for all variables in data
ind_an <- anova_ind(data_ge,
                    env = ENV,
                    gen = GEN,
                    rep = REP,
                    resp = everything())
# mean for each environment
get_model_data(ind_an)

# P-value for genotype effect
get_model_data(ind_an, "PFG")

}
}
\references{
Patterson, H.D., and E.R. Williams. 1976. A new class of
resolvable incomplete block designs. Biometrika 63:83-92.
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
