% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env_stratification.R
\name{env_stratification}
\alias{env_stratification}
\title{Environment stratification}
\usage{
env_stratification(
  .data,
  env,
  gen,
  resp,
  use = "complete.obs",
  mineval = 1,
  verbose = TRUE
)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s)}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure use, for example, \code{resp = c(var1, var2, var3)}.}

\item{use}{The method for computing covariances in the presence of missing
values. Defaults to \code{complete.obs}, i.e., missing values are handled
by casewise deletion.}

\item{mineval}{The minimum value so that an eigenvector is retained in the
factor analysis.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}
}
\value{
An object of class \code{env_stratification} which is a list with one
element per analyzed trait. For each trait, the following values are given.
\itemize{
\item \code{data} The genotype-environment means.
\item \code{cormat}: The correlation matrix among the environments.
\item \code{PCA}: The eigenvalues and explained variance.
\item \code{FA}: The factor analysis.
\item \code{env_strat}: The environmental stratification.
\item \code{mega_env_code}: The environments within each mega-environment.
\item \code{mega_env_stat}: The statistics for each mega-environment.
\item \code{KMO}: The result for the Kaiser-Meyer-Olkin test.
\item \code{MSA}: The measure of sampling adequacy for individual variable.
\item \code{communalities_mean}: The communalities' mean.
\item \code{initial_loadings}: The initial loadings.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Computes environment stratification based on factor analysis.
}
\examples{
\donttest{
library(metan)
model <-
env_stratification(data_ge,
                   env = ENV,
                   gen = GEN,
                   resp = everything())
gmd(model)

}
}
\references{
Murakami, D.M.D., and C.D.C. Cruz. 2004. Proposal of
methodologies for environment stratification and analysis of genotype
adaptability. Crop Breed. Appl. Biotechnol. 4:7-11.
}
\seealso{
\code{\link[=env_dissimilarity]{env_dissimilarity()}}
}
\author{
Tiago Olivoto, \email{tiagoolivoto@gmail.com}
}
