% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_bind.R
\name{utils_bind}
\alias{utils_bind}
\alias{rbind_fill_id}
\title{Helper function for binding rows}
\usage{
rbind_fill_id(..., .id = NULL, .fill = NA)
}
\arguments{
\item{...}{The dataframes. Either a list of data frames, or a comma-separated
list of dataframes.}

\item{.id}{Data frame identifier. If a comma-separated list of data frames is
supplied, the labels are taken from the names of the objects. When a list
of data frames is supplied, the labels are taken from the names of the
list. If no names are found, a numeric sequence is used instead.}

\item{.fill}{When row-binding, columns are matched by name, and any missing
columns will be filled with \code{NA} Defaults to \code{NA}.}
}
\value{
A data frame.
}
\description{
\itemize{
\item \code{\link[=rbind_fill_id]{rbind_fill_id()}} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Implements the common pattern of \code{do.call(rbind, dfs)}
with data frame identifier and filling of missing values.
}
}
\examples{
\donttest{
(df1 <- data.frame(v1 = c(1, 2), v2 = c(2, 3)))
(df2 <- data.frame(v3 = c(4, 5)))
rbind_fill_id(df1, df2)
rbind_fill_id(df1, df2,
             .fill = ".",
             .id = "dfs")

# Named list
list <- list(a = df1, b = df2)
rbind_fill_id(list, .id = "dfs")

# Unnamed list
list <- list(df1, df2)
rbind_fill_id(list, .id = "dfs")

}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
