% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_corvars.R
\name{get_corvars}
\alias{get_corvars}
\title{Generate normal, correlated variables}
\usage{
get_corvars(n = 10, mu, sigma, tol = 1e-06, seed = NULL)
}
\arguments{
\item{n}{The number of samples required.}

\item{mu}{A vector with the means for the variables.}

\item{sigma}{A symmetric, positive-definite matrix with the (co)variance or
correlation matrix of the variables.}

\item{tol}{Tolerance (relative to largest variance) for numerical lack of
positive-definiteness in sigma.}

\item{seed}{An integer value interpreted as seed.}
}
\value{
A tibble containing the simulated data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Given the mean and desired correlations, generate normal, correlated
variables.
}
\examples{
\donttest{
sigma <- matrix(c(1,  .3,  0,
                  .3,   1, .9,
                  0,   .9,  1),3,3)
mu <- c(6,50,5)

df <- get_corvars(n = 10000, mu = mu, sigma = sigma, seed = 101010)
mean_by(df)
cor(df)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
